#!/bin/bash
if [ $(id -u) != "0" ]; then
    printf "Error: You must be root to run this tool!\n"
    exit 1
fi
#工作目录
WORKPATH=`pwd`

ReadIni() {
    file=$1;section=$2;item=$3;
    val=$(awk -F '=' '/\['${section}'\]/{a=1} (a==1 && "'${item}'"==$1){a=0;print $2}' ${file}) 
    echo ${val}
}

#配置环境
yum -y install epel-release
/bin/cp /etc/yum.repos.d/CentOS-Base.repo /etc/yum.repos.d/CentOS-Base.repo.backup
wget -O /etc/yum.repos.d/CentOS-Base.repo http://mirrors.aliyun.com/repo/Centos-6.repo
wget -O /etc/yum.repos.d/epel.repo http://mirrors.aliyun.com/repo/epel-6.repo
yum -y install 3proxy dos2unix vim unzip wget make gcc

##读取配置文件
dos2unix config.ini
SOCKS5_PORT=`ReadIni config.ini default SOCKS5_PORT`
HTTP_PORT=`ReadIni config.ini default HTTP_PORT`
SPEED_LIMIT=`ReadIni config.ini default SPEED_LIMIT`

#IP总数
IPCOUNT=`ifconfig  | grep 'inet addr:' |grep Bcast| grep -v '127.0.0.1' | cut -d: -f2 | wc -l`

/bin/cp $WORKPATH/tpl.3proxy.cfg /etc/3proxy.cfg
/bin/cp $WORKPATH/3proxy-user-add.sh /usr/local/bin/3proxy-user-add.sh
/bin/cp $WORKPATH/3proxy-user-del.sh /usr/local/bin/3proxy-user-del.sh
/bin/cp $WORKPATH/fs-unlimit.sh /usr/local/bin/fs-unlimit.sh
#/bin/cp $WORKPATH/firewall.sh /usr/local/bin/firewall.sh
chmod 755 /usr/local/bin/*.sh
touch /etc/3proxy.passwd
USER_COUNT=`cat /etc/3proxy.passwd |wc -l`
if [ $USER_COUNT -eq 0 ]
then
	echo "defaultuser:CL:c6b01da0ad87581c8d0c0535868dc15b" > /etc/3proxy.passwd
fi

if [ $SPEED_LIMIT -gt 0 ]
then
	let "SPEED_LIMIT = $SPEED_LIMIT * 1024 * 1000" ;
	echo "bandlimin 1024000 *" >> /etc/3proxy.cfg
fi

for((i=1;i<=$IPCOUNT;i++))
do
	#循环获取IP
	IPADDR=`ifconfig  | grep 'inet addr:' |grep Bcast| grep -v '127.0.0.1' | cut -d: -f2 |sed -n "${i}p"| awk 'NR==1 { print $1}'`
	echo "socks -a -n -p${SOCKS5_PORT} -i${IPADDR} -e${IPADDR}" >> /etc/3proxy.cfg
	echo "proxy -a -n -p${HTTP_PORT} -i${IPADDR} -e${IPADDR}" >> /etc/3proxy.cfg
	echo "" >> /etc/3proxy.cfg
done


cd ${WORKPATH} 

#service iptables restart
#/usr/local/bin/firewall.sh
chkconfig 3proxy on
service 3proxy restart

RC_NUM=`cat /etc/rc.d/rc.local | grep monsocks5.sh | wc -l`
if [ $RC_NUM -eq 0 ]
then
	echo "/usr/local/bin/fs-unlimit.sh" >> /etc/rc.d/rc.local
fi



