#!/bin/bash
if [ $(id -u) != "0" ]; then
    printf "Error: You must be root to run this tool!\n"
    exit 1
fi
#工作目录
WORKPATH=`pwd`

ReadIni() {
    file=$1;section=$2;item=$3;
    val=$(awk -F '=' '/\['${section}'\]/{a=1} (a==1 && "'${item}'"==$1){a=0;print $2}' ${file}) 
    echo ${val}
}

#disable ipv6
echo "install ipv6 /bin/true" > /etc/modprobe.d/disable-ipv6.conf


##读取配置文件
#dos2unix config.ini
#SOCKS5_PORT=`ReadIni config.ini default SOCKS5_PORT`
#AUTH_URL=`ReadIni config.ini default AUTH_URL`

cd ${WORKPATH} 
/bin/cp $WORKPATH/tpl/limits.conf /etc/security/limits.conf
/bin/cp $WORKPATH/mysocks5.service /lib/systemd/system/mysocks5.service

systemctl daemon-reload
systemctl stop mysocks5

/bin/cp -f $WORKPATH/my-socks5 /usr/local/bin/my-socks5
chmod 755 /usr/local/bin/my-socks5

systemctl enable mysocks5
systemctl start mysocks5