#!/bin/bash
if [ $(id -u) != "0" ]; then
    printf "Error: You must be root to run this tool!\n"
    exit 1
fi
#工作目录
WORKPATH=`pwd`

ReadIni() {
    file=$1;section=$2;item=$3;
    val=$(awk -F '=' '/\['${section}'\]/{a=1} (a==1 && "'${item}'"==$1){a=0;print $2}' ${file}) 
    echo ${val}
}

#disable ipv6
echo "install ipv6 /bin/true" > /etc/modprobe.d/disable-ipv6.conf

yum -y install epel-release
yum -y install daemonize unzip dos2unix wget openssh-clients patch iptables make gcc vim curl-devel


##读取配置文件
dos2unix config.ini
SOCKS5_PORT=`ReadIni config.ini default SOCKS5_PORT`
AUTH_URL=`ReadIni config.ini default AUTH_URL`

cd ${WORKPATH} 


/bin/cp $WORKPATH/tpl/limits.conf /etc/security/limits.conf
/bin/mv -f $WORKPATH/my-socks5 /usr/local/bin/my-socks5
chmod 755 /usr/local/my-socks5


RC_NUM=`cat /etc/rc.local | grep my-socks5 | wc -l`
if [ $RC_NUM -eq 0 ]
then
	echo "/usr/sbin/daemonize -a -e /var/log/my-socks5-error.log -o /var/log/my-socks5-output.log /usr/local/bin/my-socks5 -listen=\"0.0.0.0:${SOCKS5_PORT}\" -auth=\"$AUTH_URL\" " >> /etc/rc.local
fi

killall my-socks5
daemonize -a -e /var/log/my-socks5-error.log -o /var/log/my-socks5-output.log /usr/local/bin/my-socks5 -listen="0.0.0.0:${SOCKS5_PORT}" -auth="$AUTH_URL"