#!/bin/bash
if [ $(id -u) != "0" ]; then
    printf "Error: You must be root to run this tool!\n"
    exit 1
fi
#工作目录
WORKPATH=`pwd`

ReadIni() {
    file=$1;section=$2;item=$3;
    val=$(awk -F '=' '/\['${section}'\]/{a=1} (a==1 && "'${item}'"==$1){a=0;print $2}' ${file}) 
    echo ${val}
}

#disable ipv6
echo "install ipv6 /bin/true" > /etc/modprobe.d/disable-ipv6.conf

yum -y install epel-release
yum -y install daemonize unzip dos2unix wget openssh-clients patch iptables make gcc vim curl-devel


##读取配置文件
dos2unix config.ini
SOCKS5_PORT=`ReadIni config.ini default SOCKS5_PORT`
AUTH_URL=`ReadIni config.ini default AUTH_URL`

cd ${WORKPATH} 


/bin/cp $WORKPATH/tpl/limits.conf /etc/security/limits.conf

/bin/cp $WORKPATH/monsocks5.sh /usr/local/bin/monsocks5.sh
chmod 755 /usr/local/bin/monsocks5.sh

killall my-socks5
/bin/cp -f $WORKPATH/my-socks5 /usr/local/bin/my-socks5
chmod 755 /usr/local/bin/my-socks5


RC_NUM=`cat /etc/rc.local | grep monsocks5.sh | wc -l`
if [ $RC_NUM -eq 0 ]
then
	echo "/usr/sbin/daemonize /usr/local/bin/monsocks5.sh " >> /etc/rc.local
fi

killall monsocks5.sh
/usr/sbin/daemonize /usr/local/bin/monsocks5.sh