﻿/// <reference path="/js/jquery.min.js" />
var themeConfig = swin.find("#themeConfig");
var configData = configData;

function loadThemeConfig() {
    var str = '';
    var homeConfigs = $.parseJSON('{' +
                                  '"cloud_home_pd":{"label":"Cloud主机套餐分组编号","type":"input","width":"130px","des":"","max":1,"data":"product"},' +
                                  '"vhost_home_pd":{"label":"推荐虚拟主机套餐编号","type":"input","width":"130px","des":"","max":1,"data":"product"},' +
                                  '"server_home_pd":{"label":"独服租用套餐分组编号","type":"input","width":"130px","des":"","max":1,"data":"product"},' +								  
                                  '"cloud_default_pg":{"label":"默认显示的VPS云主机产品分组","type":"input","width":"130px","des":"","max":1,"data":"productgroup"},' +
                                  '"cloud_pg":{"label":"允许显示的VPS云主机产品分组","type":"input","width":"200px","des":"","max":0,"data":"productgroup"},' +	
                                  '"vhost_default_pg":{"label":"默认虚拟主机栏的分组编号","type":"input","width":"200px","des":"","max":1,"data":"productgroup"},' +
								  '"vhost_pg":{"label":"要显示的虚拟主机产品分组编号","type":"input","width":"200px","des":"","max":0,"data":"productgroup"},' +
								  '"server_default_pg":{"label":"默认独服租用分组编号","type":"input","width":"200px","des":"","max":1,"data":"productgroup"},' +
								  '"server_pgs":{"label":"要显示的独服租用产品分组","type":"input","width":"200px","des":"","max":0,"data":"productgroup"},' +
								  '"hosting_default_pg":{"label":"默认独服托管分组编号","type":"input","width":"200px","des":"","max":1,"data":"productgroup"},' +
								  '"hosting_pgs":{"label":"要显示的独服托管产品分组","type":"input","width":"200px","des":"","max":0,"data":"productgroup"},' +
								  '"domain_pid":{"label":"域名注册所使用的产品编号","type":"input","width":"200px","des":"","max":1,"data":"product"},' +
                                  '"domain_news_pg":{"label":"域名注册新闻编号","type":"input","width":"130px","des":"","max":1,"data":"newstype"},' +
                                  '"about_pg":{"label":"“关于我们”栏目相关的文章类别","type":"select","width":"","des":"","max":0,"data":"newstype"}' +
                                  '}');

    var configDataValue;
    $.each(homeConfigs, function (key, value) {
        switch (key) {
            case 'cloud_home_pd':
                str += '<strong>首页内容选项设置：</strong><br />';
                break;
            case 'cloud_default_pg':
                str += '<strong>VPS云主机页面设置：</strong><br />';
                break;
            case 'vhost_default_pg':
                str += '<strong>虚拟主机页面设置：</strong><br />';
                break;
            case 'server_default_pg':
                str += '<strong>服务器租用页面设置：</strong><br />';
                break;
            case 'hosting_default_pg':
                str += '<strong>服务器托管页面设置：</strong><br />';
                break;
            case 'domain_pid':
                str += '<strong>域名注册页面设置：</strong><br />';
                break;
            case 'about_pg':
                str += '<strong>其它设置：</strong><br />';
                break;
        }
        configDataValue = configData[key] == undefined ? '0' : configData[key];
        str += value.label + '：<input type="hidden" name="cname_' + key + '" value="' + key + '"/>';
        if (value.type == 'input') str += '<input style="' + (value.width != '' ? 'width:' + value.width + ';' : '') + '" type="text" class="text" value="' + configDataValue + '" name="cvalue_' + key + '" /> <input type="button" class="button" value="选择" name="btn_' + key + '"/> ';
        else if (value.type == 'select') str += '<select style="' + (value.width != '' ? 'width:' + value.width + ';' : '') + '" data="' + value.data + '" name="cvalue_' + key + '" ><option value="' + configDataValue + '">Loading...</option></select> ';
        if (value.des != '') str += ' ' + value.des;
        str += '<br />';
    });

    
    themeConfig.html(str);

    themeConfig.find(".button").click(function () {
        var cKey = $(this).attr("name").substring(4);
        var cValue = homeConfigs[cKey];
        switch (cValue.data) {
            case 'product':
            case 'productgroup':
                selectProducts(cKey, '选择：' + cValue.label, cValue.data, cValue.max, 0);
                break;
            case 'news':
            case 'newstype':
                selectNews(cKey, '选择：' + cValue.label, cValue.data, cValue.max, 0);
                break;
            case 'os':
                _setOS(cKey, 0);
                break;
        }
    });

    var newsTypeSelects = swin.find("select[data='newstype']");
    if (newsTypeSelects.length > 0) {
        $.getJSON("?c=ajax&a=true&dt=config&p1=news_type&rt=json&p2=5&" + new Date(), function (rdata) {
            if (rdata[0].isEmpty != 'true') {
                var tempStr = '';
                $.each(rdata[0].cconfig, function (key, value) {
                    tempStr += '<option value="' + key.substring(3) + '">' + value + '</option>';
                });
                var cSelect;
                $(newsTypeSelects).each(function () {
                    cSelect = $(this);
                    var oValue = cSelect.val();
                    cSelect.find("option").remove();
                    cSelect.append(tempStr).val(oValue);
                });
            }
        });
    }
}

function _addOS(oid, oname) {
    suwin.find("#oslist").append('<li>系统模板ID编号：<input type="text" class="text center" name="oid" style="width:50px" value="' + oid + '"/> &nbsp;&nbsp;操作系统名称：<input type="text" class="text" name="oname" value="' + oname + '"/> &nbsp;&nbsp;<input type="button" class="button" value="删除" onclick="_delOS(this)"/></li>');
}

function _delOS(ca) {
    $(ca).parent().remove();
}

function _setOS(key, action) {
    var str = '';
    if (action == 0) {
        var cInput = swin.find("input[name='cvalue_" + key + "']");
        var cOS = cInput.val().split('|');
        str = '<strong>设置允许使用的VPS操作系统列表：</strong> <input type="button" class="button" value="添加" onclick="_addOS(\'0\',\'\')"/><br />' +
              '<span style="color:#ff4700;">相关的编号请登陆您的<strong>XenSystem</strong>后台“操作系统模板设置”中获取。</span><ul id="oslist"></ul>';
        suwin.html(str);
        if (cOS[0].indexOf(',') > 0) {
            for (i = 0; i < cOS.length; i++) {
                _addOS(cOS[i].substring(0, cOS[i].indexOf(',')), cOS[i].substring(cOS[i].indexOf(',') + 1));
            }
        }
        suwin.dialog({ title: '设置允许使用的VPS操作系统列表', autoOpen: false, resizable: false, width: 750, height: 550, modal: true, buttons: { "保 存": function () { _setOS(key, 1); }, "取 消": function () { $(this).dialog("close"); } } }).dialog("open");
    } else {
        var lis = suwin.find("li");
        if (lis.length < 1) alert('请添加允许使用的VPS操作系统！');
        else {
            $(lis).each(function () {
                str += '|' + $(this).find("input[name='oid']").val() + ',' + $(this).find("input[name='oname']").val();
            });
            str = str.substring(1);
            swin.find("input[name='cvalue_" + key + "']").val(str);
            suwin.dialog("close");
        }
    }
}

loadThemeConfig();
