﻿/*!
	jQuery Cookie Plugin
	https://github.com/carhartl/jquery-cookie
	
	Copyright 2011, Klaus Hartl
	Dual licensed under the MIT or GPL Version 2 licenses.
	http://www.opensource.org/licenses/mit-license.php
	http://www.opensource.org/licenses/GPL-2.0
*/
//<reference path="/js/jquery.min.js" />
(function(a){a.cookie=function(b,c,d){if(arguments.length>1&&(!/Object/.test(Object.prototype.toString.call(c))||c===null||c===undefined)){d=a.extend({},d);if(c===null||c===undefined){d.expires=-1}if(typeof d.expires==="number"){var e=d.expires,f=d.expires=new Date;f.setDate(f.getDate()+e)}c=String(c);return document.cookie=[encodeURIComponent(b),"=",d.raw?c:encodeURIComponent(c),d.expires?"; expires="+d.expires.toUTCString():"",d.path?"; path="+d.path:"",d.domain?"; domain="+d.domain:"",d.secure?"; secure":""].join("")}d=c||{};var g=d.raw?function(a){return a}:decodeURIComponent;var h=document.cookie.split("; ");for(var i=0,j;j=h[i]&&h[i].split("=");i++){if(g(j[0])===b)return g(j[1]||"")}return null}})(jQuery)

// Configuration
var contentSliderSpeed = 5000;
var animationSpeed = 200;


// DOM is ready
$(function () {
    // Animate navigation
    var siteHeaderNavigationActive = false;
    $('div.siteHeader ul.navigation li').hover(function () {
        $(this).find('ul.dropdown').stop(true, true).hide().animate({ height: 'show' }, animationSpeed);
    }, function () {
        $(this).find('ul.dropdown').stop(true, true).show().animate({ opacity: 'hide' }, animationSpeed);
    });

    // Render content slider
    var contentSlider = $('div.contentSlider');
    var contentSlide = contentSlider.find('div.slide');
    if (contentSlide.length > 1) {
        // Calculate slide switch element width
        var contentSliderCount = contentSlide.length;
        var slideSwitchWidth = Math.round((480 - ((contentSlide.length - 1) * 9)) / contentSliderCount) - 2;

        // Prepare output		
        var printSwitch = '<div class="slideSwitch">';

        // Add a switch for every slide
        $.each(contentSlide, function (key) {
            // Hide slide if it is not the first
            if (key != 0) {
                $(this).hide();
            }

            // Get label for switch
            var label = $(this).find('.slideSwitchLabel').html();

            // Use a number if no label was given			
            if (label === null) {
                label = key + 1;
            }

            // Add id to switch with slide number
            $(this).attr('id', 'slide-' + key);
            printSwitch += '<div id="switchSlide-' + key + '" style="width: ' + slideSwitchWidth + 'px;">' + label + '</div>';
        });

        // Output slide switches and adapt design
        contentSlider.css({ height: '380px' });
        contentSlide.css({ height: '380px', overflow: 'visible' });
        contentSlider.find('div.slide img').css({ marginTop: 0 });
        contentSlider.find('div.center').prepend(printSwitch + '</div>');
        contentSlider.find('div.slideSwitch div:first').addClass('active');
        contentSlider.find('div.slideSwitch div:last').css({ marginRight: 0 });

        // Create auto slider
        var autoSlideTimer;
        var autoSlide = function () {
            // Get active id
            var activeId = contentSlider.find('div.slideSwitch div.active').attr('id').split('-');
            activeId = activeId[1];

            // Get next id and store it in active id
            if (activeId == (contentSliderCount - 1)) {
                activeId = 0;
            }
            else {
                activeId++;
            }

            // Call next slide
            $('#switchSlide-' + activeId).click();

            // Create timing event for next slide
            autoSlideTimer = window.setTimeout(autoSlide, contentSliderSpeed);
        };

        // Create timing event for next slide
        autoSlideTimer = window.setTimeout(autoSlide, contentSliderSpeed);

        // Add event listener for click
        var contentSliderActive = false;
        contentSlider.delegate('div.slideSwitch div', 'click', function (event) {
            // Deny click on active element
            if ($(this).is('.active')) {
                return false;
            }

            // Stop current animation if still active
            if (contentSliderActive) {
                $('div.contentSlider div.slide, div.contentSlider div.slide div.information, div.contentSlider div.slide img').stop(true, true);
            }

            // Set content slider active
            contentSliderActive = true;

            // Kill auto slide if user clicked		
            if (typeof event.which !== 'undefined') {
                window.clearTimeout(autoSlideTimer);
            }

            // Get slide id
            var id = $(this).attr('id').split('-');
            id = id[1];

            // Change slide and adapt design
            $('div.contentSlider div.slideSwitch div').removeClass('active');
            $(this).addClass('active');

            // Active slide
            var activeSlide = $('div.contentSlider .slide:visible');

            // Animate slide change
            activeSlide.find('div.information').animate({ marginLeft: '-420px', opacity: 0 }, 400, function () {
                activeSlide.hide();
                $(this).css({ marginLeft: 0, opacity: 1 });
            });

            activeSlide.find('img').animate({ marginRight: '-480px', opacity: 0 }, 400, function () {
                $(this).css({ marginRight: 0, opacity: 1 });
            });

            $('#slide-' + id).css({ position: 'absolute', top: '-340px' }).show().animate({ top: '0' }, 400, function () {
                $(this).css({ position: 'relative' });

                // Set content slider inactive
                contentSliderActive = false;
            });
        });
    }

    // Handle image zoom function
    $('a.imageZoom').click(function () {
        // Get link to image
        var imageLink = $(this).attr('href');

        // Put image in DOM
        $('div.siteWrapper').prepend('<div class="siteOverlay"></div><div class="siteLoading"><div></div></div><img class="imageZoomBox" src="' + imageLink + '" alt="Zoom" /><div class="imageZoomClose"></div>');

        // Animate image box
        $('div.siteOverlay').css({ opacity: 0 }).show().animate({ opacity: 0.9 }, animationSpeed);
        $('div.siteLoading').animate({ opacity: 'show' }, animationSpeed);

        // Load the image
        var image = $('img.imageZoomBox');
        $(image).load(function () {
            // Process image dimensions
            var imageRatio = 0;
            var imageWidth = $(this).width();
            var imageHeight = $(this).height();
            var windowWidth = $(window).width();
            var windowHeight = $(window).height();
            var maxWidth = windowWidth - 80;
            var maxHeight = windowHeight - 80;

            // Check image width
            if (imageWidth > maxWidth) {
                imageRatio = maxWidth / imageWidth;
                imageWidth = imageWidth * imageRatio;
                imageHeight = imageHeight * imageRatio;
            }

            // Check image height
            if (imageHeight > maxHeight) {
                imageRatio = maxHeight / imageHeight;
                imageWidth = imageWidth * imageRatio;
                imageHeight = imageHeight * imageRatio;
            }

            // Hide loading indicator
            $('div.siteLoading').hide();

            // Show and animate image
            $(this).css({ width: 0, height: 0 }).animate({ opacity: 'show', width: imageWidth + 'px', height: imageHeight + 'px', marginTop: '-' + ((imageHeight / 2) + 20) + 'px', marginLeft: '-' + ((imageWidth / 2) + 20) + 'px' }, animationSpeed, function () {
                $('div.imageZoomClose').css({ marginLeft: ((imageWidth / 2) - 20) + 'px', marginTop: '-' + ((imageHeight / 2) + 20) + 'px' }).animate({ opacity: 'show' }, animationSpeed);
            })
        });

        return false;
    });

    // Handle close event on overlay or imagebox
    $('div.siteWrapper').delegate('div.siteOverlay, div.imageZoomClose, div.siteLoading', 'click', function () {
        $('div.siteOverlay, img.imageZoomBox, div.imageZoomClose, div.siteLoading').animate({ opacity: 'hide' }, animationSpeed, function () {
            $(this).remove();
        });
    });

    // Generate tab navigation
    if ($('div.tabWrapper').length != 0) {
        $('div.tabWrapper').each(function () {
            // Prepare tab output
            var printTabs = '<ul class="tabs">';
            var tabContent = $(this).find('.tabContent');
            var tabCount = tabContent.length;

            $(tabContent).each(function (key) {
                // Hide tab if it is not the first
                if (key != 0) {
                    $(this).hide();
                }

                // Get label for tab
                var label = $(this).find('.label').text();

                // Use a number if no label was given			
                if (!label) {
                    label = 'Tab ' + (key + 1);
                }

                // Add id to tab content
                $(this).addClass('tab-' + key);
                printTabs += '<li class="tabTrigger-' + key + '">' + label + '</li>';
            });

            // Add tabs
            $(this).prepend(printTabs + '</ul>');
            $(this).find('li:first').addClass('active');
        });
    }

    // Handle click on tabs
    $('.tabWrapper').delegate('ul.tabs li', 'click', function () {
        // Deny click on active element
        if ($(this).is('.active')) {
            return false;
        }

        // Get tab id
        var id = $(this).attr('class').split('-');
        id = id[1];

        // Display and animate new tab content
        var parent = $(this).parent().parent();
        parent.find('ul.tabs li').removeClass('active');
        $(this).addClass('active');
        parent.find('.tabContent').hide()
        parent.find('.tab-' + id).animate({ opacity: 'show' }, animationSpeed);
    });

});


function rGet(cqstr, name) {
    if (cqstr == '') cqstr = location.search;
    name += '=';
    var value = cqstr.replace('?' + name, '&' + name);
    name = '&' + name;
    if (value.indexOf(name) > -1) {
        value = value.substring(value.indexOf(name) + name.length);
        if (value.indexOf('&') > -1) value = value.substring(0, value.indexOf('&'));
        if (value.indexOf('#') > -1) value = value.substring(0, value.indexOf('#'));
    } else value = '';
    return value;
}

String.prototype.replaceAll = function (s1, s2) {
    return this.replace(new RegExp(s1, "gm"), s2);
}

var curl = top.location.toString();
if (curl.indexOf("&rn=") > 0) curl = curl.substring(0, curl.indexOf("&rn="));
var cAction = rGet(curl, 'c');

function getUnixTime(time) {
    var yt = new Date(time * 1000);
    var nt = yt.getFullYear() + '-' + (yt.getMonth() + 1) + '-' + yt.getDate() + ' ' + yt.getHours() + ':' + yt.getMinutes() + ':' + yt.getSeconds();
    return nt;
}
function ajaxLoading(str) {
    if (str == undefined) str = 'Loading...';
    return '&nbsp;<br /><p style="text-align:center;line-height:30px;">' + str + '<br /><img src="/images/loading.gif" alt="Loading..."/></p>';
}

function processing(str) {
    $("#processing").html(ajaxLoading(str));
    $("#processing").dialog({ title: "", autoOpen: false, resizable: false, modal: true }).dialog("open");
    
}

function showResults(str, delay, cmd) {
    $("#processing p:first").html(str);
    switch (cmd) {
        case 'close':
            cmd = '$("#processing").dialog("close");';
            break;
        case 'reload':
            cmd = 'top.location.reload();';
            break;
    }
    if (delay > 0) setTimeout(cmd, delay);
}

function htmlEncode(html) {
    var temp = document.createElement("div");
    (temp.textContent != null) ? (temp.textContent = html) : (temp.innerText = html);
    var output = temp.innerHTML;
    temp = null;
    return output;
}

function htmlDecode(text) {
    var temp = document.createElement("div");
    temp.innerHTML = text;
    var output = temp.innerText || temp.textContent;
    temp = null;
    return output;
}

function getPrice(pprice, psconfig, pcycle) {
    var pstr = psconfig.pricedes == undefined ? '' : psconfig.pricedes;
    if (pstr == undefined) pstr = '';
    //if (pstr != '') alert(psconfig.pricedes);
    if (pstr == '') {
        var pps = pprice.cprice.split(',');
        var pcs = pprice.cycle.split(',');
        var p;
        var cps = '';
        for (p = 0; p < pps.length; p++) {
            if (pps[p] != '0') {
                cps = '<span>' + pps[p] + '</span>元/';
                switch (pcs[p]) {
                    case '1': cps += '月'; break;
                    case '3': cps += '季'; break;
                    case '6': cps += '半年'; break;
                    case '12': cps += '年'; break;
                    case '24': cps += '2年'; break;
                }
                if (parseInt(pcs[p]) == pcycle || (pcycle < 0 && pcycle == -(p+1))) {
                    pstr = cps;
                    break;
                }
                pstr += cps + '&nbsp;&nbsp;&nbsp;';
            }
        }

    }
    return pstr;
}




function checkDomain(obj,pid) {
    var domainname = $(obj).find("input[name='domainname']").val();
    if (domainname == '') {
        alert('请输入要查询的域名！');
        return false;
    }
    var domainsuffixs = $(obj).find("input[name='domainsuffix']:checked");
    if (domainsuffixs.length < 1) {
        alert('请选择要查询的域名后缀！');
        return false;
    }
    var str = '<ul class="domainul"><li style="font-weight:bold; border-bottom:1px dashed #666;">域名查询结果</li>';
    var dn, domains ='';
    $(domainsuffixs).each(function (i) {
        dn = domainname + $(domainsuffixs[i]).val();
        domains += ',' + dn;
        str += '<li><span id="yname">' + dn + '</span><span id="end" class="r_' + dn.replaceAll("\\.", "") + '">Checking...</span></li>';
    });
    str += '</ul>';
    swin.html(str);
    domainAPI(domains, 1,pid);
    swin.dialog({ title: "域名查询", autoOpen: false, resizable: false, width: 398, modal: true, buttons: { "关 闭": function () { $(this).dialog("close"); } } }).dialog("open");
    return false;
}

function domainAPI(domains, i,pid) {
    var _domains = domains.split(',');
    if (_domains.length <= i) return false;
    var rmsg;
    $.getJSON("process.aspx?c=jsapi&action=domain&domain=" + _domains[i] + "&" + new Date(), function (rdata) {
        rmsg = '';
        if (rdata.status == 'error') rmsg = rdata.msg;
        else if (rdata.status == 'unavailable') rmsg = '不可注册';
        else if (rdata.status == 'available') rmsg = '<input type="submit" value="马上注册" onclick="placeOrder(0,\'?c=order&ptype=3&pid='+pid+'&domain=' + _domains[i]+'\');" class="domain_yes" />';
        if (rmsg.indexOf('Error:') > -1) rmsg = rmsg.replace('Error:', '');
        swin.find('.r_' + _domains[i].replaceAll('\\.', '')).html(rmsg);
        i++;
        domainAPI(domains, i,pid);
    });
}