#!/bin/bash

echo "Radius Manager installer"
echo "Copyright 2004-2011, DMA Softlab LLC"
echo "All right reserved."
echo
echo "(Use CTRL+C to abort any time)"
echo

# select OS version

echo "Select the type of your operating system: "
echo "1. Redhat (Fedora, CentOS etc.)"
echo "2. Debian (Ubuntu etc.)"
echo
echo -n "Choose an option: [1] "
read ostype
if [ -z "$ostype" ]; then
    ostype="1"
fi
case $ostype in
    1 ) echo "Selected operating system is: REDHAT"
        ;;
    2 ) echo "Selected operating system is: DEBIAN"
        ;;
    * ) echo "Invalid selection. Installation aborted."
        echo
        exit
        ;;
esac

# determine installatio type

echo
echo "Select installation type: "
echo "1. New installation"
echo "2. Upgrade old system"
echo
echo -n "Choose an option: [1] "
read intype
if [ -z "$intype" ]; then
    intype="1"
fi
case $intype in
    1 ) echo "Selected installation method: NEW INSTALLATION"
        install=1
        ;;
    2 ) echo "Selected installation method: UPGRADE"
        install=2
        echo
        echo "0.  v1.1.5"
        echo "1.  v2.0.0"
        echo "2.  v2.0.1"
        echo "3.  v2.0.2"
        echo "4.  v2.5.0"
        echo "5.  v2.5.1"
        echo "6.  v3.0.0"
        echo "7.  v3.0.1"
        echo "8.  v3.1.0"
        echo "9.  v3.1.1"
        echo "10. v3.1.2"
        echo "11. v3.2.0"
        echo "12. v3.2.1"
        echo "13. v3.2.2"
        echo "14. v3.3.0"
        echo "15. v3.4.0"
        echo "16. v3.4.1"
        echo "17. v3.5.0"
        echo "18. v3.6.0"
        echo "19. v3.6.1"
        echo "20. v3.7.0"
        echo "21. v3.8.0"
        echo
        ex=0
        until [ $ex = 1 ]; do
          echo -n "Select current installed version: "
          read curver
          case $curver in
            0 ) echo "Current installed version is 1.1.5"
              ex=1
              ;;
            1 ) echo "Current installed version is 2.0.0"
              ex=1
              ;;
            2 ) echo "Current installed version is 2.0.1"
              ex=1
              ;;
            3 ) echo "Current installed version is 2.0.2"
              ex=1
              ;;
            4 ) echo "Current installed version is 2.5.0"
              ex=1
              ;;
            5 ) echo "Current installed version is 2.5.1"
              ex=1
              ;;
            6 ) echo "Current installed version is 3.0.0"
              ex=1
              ;;
            7 ) echo "Current installed version is 3.0.1"
              ex=1
              ;;
            8 ) echo "Current installed version is 3.1.0"
              ex=1
              ;;
            9 ) echo "Current installed version is 3.1.1"
              ex=1
              ;;
            10 ) echo "Current installed version is 3.1.2"
              ex=1
              ;;
            11 ) echo "Current installed version is 3.2.0"
              ex=1
              ;;
            12 ) echo "Current installed version is 3.2.1"
              ex=1
              ;;
            13 ) echo "Current installed version is 3.2.2"
              ex=1
              ;;
            14 ) echo "Current installed version is 3.3.0"
              ex=1
              ;;
            15 ) echo "Current installed version is 3.4.0"
              ex=1
              ;;
            16 ) echo "Current installed version is 3.4.1"
              ex=1
              ;;
            17 ) echo "Current installed version is 3.5.0"
              ex=1
              ;;
            18 ) echo "Current installed version is 3.6.0"
              ex=1
              ;;
            19 ) echo "Current installed version is 3.6.1"
              ex=1
              ;;
            20 ) echo "Current installed version is 3.7.0"
              ex=1
              ;;
            21 ) echo "Current installed version is 3.8.0"
              ex=1
              ;;
            * ) echo "Wrong selection. Installation aborted."
	      echo                                                                                        
              exit                                                                                        
              ;;
          esac
        done
        ;;
    * ) echo "Wrong selection. Installation aborted."
        echo
        exit
        ;;
esac

# get www path

if [ "$ostype" = "1" ]; then
  defpath="/var/www/html"
else
  defpath="/var/www"
fi
ex=0
until [ $ex = 1 ]; do
  echo -n "WWW root path: [$defpath] "
  read inpath

  if [ -n "$inpath" ]; then
    wwwpath=$inpath
  else
    wwwpath=$defpath
  fi
  
  # check if the www path writable
  
  if [ -w $wwwpath ]; then
    if [ -d "$wwwpath/radiusmanager" ]; then
      echo -n "Directory $wwwpath/radiusmanager already exists. Overwrite? [n] "
      read overwrite
      if [ -n "$overwrite" ]; then
        if [ "$overwrite" = "y" ]; then
          ex=1      
        fi
      fi
    else
      ex=1
    fi
  else
    echo "Directory $wwwpath doesn't exist"
  fi
done

# get RADIUS mysql host

defhost="localhost"
echo -n "RADIUS database host: [$defhost] "
read inhost
if [ -n "$inhost" ]; then
  radhost=$inhost
else
  radhost=$defhost
fi

# get RADIUS username

defusr="radius"
echo -n "RADIUS database username: [$defusr] "
read inusr
if [ -n "$inusr" ]; then
  myusr_rad=$inusr
else
  myusr_rad=$defusr
fi

# get RADIUS password

defpsw="radius123"
echo -n "RADIUS database password: [$defpsw] "
read inpsw
if [ -n "$inpsw" ]; then
  mypsw_radius=$inpsw
else
  mypsw_radius=$defpsw
fi

# get CTS mysql host

defhost="localhost"
echo -n "CTS database host: [$defhost] "
read inhost
if [ -n "$inhost" ]; then
  ctshost=$inhost
else
  ctshost=$defhost
fi

# get CTS username

defusr="conntrack"
echo -n "CTS database username: [$defusr] "
read inusr
if [ -n "$inusr" ]; then
  myusr_cts=$inusr
else
  myusr_cts=$defusr
fi

# get CTS password

defpsw="conn123"
echo -n "CTS database password: [$defpsw] "
read inpsw
if [ -n "$inpsw" ]; then
  mypsw_cts=$inpsw
else
  mypsw_cts=$defpsw
fi

# get freeradius user

defradusr="root"
echo -n "Freeradius UNIX user: [$defradusr] "
read inradusr
if [ -n "$inradusr" ]; then
  radusr=$inradusr
else
  radusr=$defradusr
fi

# get httpd user

if [ "$ostype" = "1" ]; then
  defhttpusr="apache"
else
  defhttpusr="www-data"
fi
echo -n "Httpd UNIX user: [$defhttpusr] "
read inhttpusr
if [ -n "$inhttpusr" ]; then
  httpusr=$inhttpusr
else
  httpusr=$defhttpusr
fi

# create rmpoller service?

echo -n "Create rmpoller service: [y] "
read inrmplr
if [ -z "$inrmplr" ]; then
  rmplr="1"
else
  if [ "$inrmplr" = "y" ]; then
    rmplr="1"
  else
    rmplr="0"
  fi
fi

# create rmconntrack service?

echo -n "Create rmconntrack service: [y] "
read inrmctr
if [ -z "$inrmctr" ]; then
  rmctr="1"
else
  if [ "$inrmctr" = "y" ]; then
    rmctr="1"
  else
    rmctr="0"
  fi
fi

# create database backup?

echo -n "Back up RADIUS database: [y] "
read inbackup
if [ -z "$inbackup" ]; then
  backup="1"
else
  if [ "$inbackup" = "y" ]; then
    backup="1"
  else
    backup="0"
  fi
fi

# sure to start?

echo
if [ "$install" = "1" ]; then
  echo "WARNING! If You continue You will overwrite the existing RADIUS database!"
  echo
  echo -n "Are You sure to start the installation? [n] "
else
  echo "WARNING! Create a full database backup before You proceed!"
  echo
  echo -n "Are You sure to start the upgrade? [n] "
fi
read sure
if [ -n "$sure" ]; then
  if [ "$sure" = "y" ]; then
    echo "Starting installation process..."
    echo
  else
    echo "Installation aborted"
    echo
    exit
  fi
else
    echo "Installation aborted"
    echo
    exit
fi

# stop services

if [ "$install" = "2" ]; then
  /etc/init.d/rmpoller stop
  /etc/init.d/rmconntrack stop
fi

# backup radiusmanager.cfg

if [ -f "/etc/radiusmanager.cfg" ]; then
  echo "Backing up radiusmanager.cfg"
  mv /etc/radiusmanager.cfg /etc/radiusmanager.bak
fi

# delete index.php

if [ -f "$wwwpath/radiusmanager/index.php" ]; then
  echo "Deleting old index.php"
  rm $wwwpath/radiusmanager/index.php
fi

# delete userinfo.php

if [ -f "$wwwpath/radiusmanager/userinfo.php" ]; then
  echo "Deleting old userinfo.php"
  rm $wwwpath/radiusmanager/userinfo.php
fi

# backup system_cfg.php

if [ -f "$wwwpath/radiusmanager/config/system_cfg.php" ]; then
  echo "Backing up system_cfg.php"
  mv $wwwpath/radiusmanager/config/system_cfg.php $wwwpath/radiusmanager/config/system_cfg_bak.php
fi

# backup netcash_cfg.php

if [ -f "$wwwpath/radiusmanager/config/netcash_cfg.php" ]; then
  echo "Backing up netcash_cfg.php"
  mv $wwwpath/radiusmanager/config/netcash_cfg.php $wwwpath/radiusmanager/config/netcash_cfg_bak.php
fi

# backup paypal_cfg.php

if [ -f "$wwwpath/radiusmanager/config/paypal_cfg.php" ]; then
  echo "Backing up paypal_cfg.php"
  mv $wwwpath/radiusmanager/config/paypal_cfg.php $wwwpath/radiusmanager/config/paypal_cfg_bak.php
fi

# backup authorizenet_cfg.php

if [ -f "$wwwpath/radiusmanager/config/authorizenet_cfg.php" ]; then
  echo "Backing up authorizenet_cfg.php"
  mv $wwwpath/radiusmanager/config/authorizenet_cfg.php $wwwpath/radiusmanager/config/authorizenet_cfg_bak.php
fi

# backup dps_cfg.php

if [ -f "$wwwpath/radiusmanager/config/dps_cfg.php" ]; then
  echo "Backing up dps_cfg.php"
  mv $wwwpath/radiusmanager/config/dps_cfg.php $wwwpath/radiusmanager/config/dps_cfg_bak.php
fi

# backup 2co_cfg.php

if [ -f "$wwwpath/radiusmanager/config/2co_cfg.php" ]; then
  echo "Backing up 2co_cfg.php"
  mv $wwwpath/radiusmanager/config/2co_cfg.php $wwwpath/radiusmanager/config/2co_cfg_bak.php
fi

# copy web content

echo "Copying WEB content to $wwwpath/radiusmanager"
cp -r www/radiusmanager $wwwpath
chown $httpusr $wwwpath/radiusmanager/config/system_cfg.php
chown $httpusr $wwwpath/radiusmanager/config/paypal_cfg.php
chown $httpusr $wwwpath/radiusmanager/config/netcash_cfg.php
chown $httpusr $wwwpath/radiusmanager/config/authorizenet_cfg.php
chown $httpusr $wwwpath/radiusmanager/config/dps_cfg.php
chown $httpusr $wwwpath/radiusmanager/config/2co_cfg.php
chmod 600 $wwwpath/radiusmanager/config/system_cfg.php
chmod 600 $wwwpath/radiusmanager/config/paypal_cfg.php
chmod 600 $wwwpath/radiusmanager/config/netcash_cfg.php
chmod 600 $wwwpath/radiusmanager/config/authorizenet_cfg.php
chmod 600 $wwwpath/radiusmanager/config/dps_cfg.php
chmod 600 $wwwpath/radiusmanager/config/2co_cfg.php

# chmod and copy binaries

echo "Copying binaries to /usr/local/bin"
chmod 755 bin/rm*
cp bin/rm* /usr/local/bin

echo "Copying rootexec to /usr/local/sbin"
cp bin/rootexec /usr/local/sbin
chmod 4755 /usr/local/sbin/rootexec

# chmod and copy radiusmanager.cfg

echo "Copying radiusmanager.cfg to /etc"
cp etc/radiusmanager.cfg /etc
chown $radusr /etc/radiusmanager.cfg
chmod 600 /etc/radiusmanager.cfg

# create database backup

if [ "$backup" = "1" ]; then
  echo "Backing up RADIUS database..."
  mysqldump -h $radhost -u $myusr_rad -p$mypsw_radius radius > backup.sql
fi

# create or upgrade tables

if [ "$install" = "1" ]; then
  echo "Creating MySQL tables"
  mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/radius.sql
  mysql -h $radhost -u $myusr_cts -p$mypsw_cts conntrack < sql/conntrack.sql
else
  echo "Upgrading MySQL tables. Please be patient."

  if [ 1 -gt $curver ]; then
    echo "Upgrading to version 2.0.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-1.1.5_2.0.0.sql
  fi
  
  if [ 2 -gt $curver ]; then
    echo "Upgrading to version 2.0.1"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-2.0.0_2.0.1.sql
  fi

  if [ 3 -gt $curver ]; then
    echo "Upgrading to version 2.0.2"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-2.0.1_2.0.2.sql
  fi

  if [ 4 -gt $curver ]; then
    echo "Upgrading to version 2.5.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-2.0.2_2.5.0.sql
  fi

  if [ 5 -gt $curver ]; then
    echo "Upgrading to version 2.5.1"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-2.5.0_2.5.1.sql
  fi

  if [ 6 -gt $curver ]; then
    echo "Upgrading to version 3.0.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-2.5.1_3.0.0.sql
  fi

  if [ 7 -gt $curver ]; then
    echo "Upgrading to version 3.0.1"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.0.0_3.0.1.sql
  fi

  if [ 8 -gt $curver ]; then
    echo "Upgrading to version 3.1.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.0.1_3.1.0.sql
  fi

  if [ 9 -gt $curver ]; then
    echo "Upgrading to version 3.1.1"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.1.0_3.1.1.sql
  fi

  if [ 10 -gt $curver ]; then
    echo "Upgrading to version 3.1.2"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.1.1_3.1.2.sql
  fi

  if [ 11 -gt $curver ]; then
    echo "Upgrading to version 3.2.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.1.2_3.2.0.sql
  fi
  
  if [ 12 -gt $curver ]; then
    echo "Upgrading to version 3.2.1"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.2.0_3.2.1.sql
  fi

  if [ 13 -gt $curver ]; then
    echo "Upgrading to version 3.2.2"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.2.1_3.2.2.sql
  fi

  if [ 14 -gt $curver ]; then
    echo "Upgrading to version 3.3.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.2.2_3.3.0.sql
    mysql -h $ctshost -u $myusr_cts -p$mypsw_cts conntrack < sql/upgrade_cts-3.2.2_3.3.0.sql
  fi

  if [ 15 -gt $curver ]; then
    echo "Upgrading to version 3.4.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.3.0_3.4.0.sql
    mysql -h $ctshost -u $myusr_cts -p$mypsw_cts conntrack < sql/upgrade_cts-3.3.0_3.4.0.sql
  fi

  if [ 16 -gt $curver ]; then
    echo "Upgrading to version 3.4.1"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.4.0_3.4.1.sql
    mysql -h $ctshost -u $myusr_cts -p$mypsw_cts conntrack < sql/upgrade_cts-3.4.0_3.4.1.sql
  fi

  if [ 17 -gt $curver ]; then
    echo "Upgrading to version 3.5.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.4.1_3.5.0.sql
    mysql -h $ctshost -u $myusr_cts -p$mypsw_cts conntrack < sql/upgrade_cts-3.4.1_3.5.0.sql
  fi

  if [ 18 -gt $curver ]; then
    echo "Upgrading to version 3.6.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.5.0_3.6.0.sql
    mysql -h $ctshost -u $myusr_cts -p$mypsw_cts conntrack < sql/upgrade_cts-3.5.0_3.6.0.sql
  fi

  if [ 19 -gt $curver ]; then
    echo "Upgrading to version 3.6.1"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.6.0_3.6.1.sql
    mysql -h $ctshost -u $myusr_cts -p$mypsw_cts conntrack < sql/upgrade_cts-3.6.0_3.6.1.sql
  fi

  if [ 20 -gt $curver ]; then
    echo "Upgrading to version 3.7.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.6.1_3.7.0.sql
    mysql -h $ctshost -u $myusr_cts -p$mypsw_cts conntrack < sql/upgrade_cts-3.6.1_3.7.0.sql
  fi

  if [ 21 -gt $curver ]; then
    echo "Upgrading to version 3.8.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.7.0_3.8.0.sql
    mysql -h $ctshost -u $myusr_cts -p$mypsw_cts conntrack < sql/upgrade_cts-3.7.0_3.8.0.sql
  fi

  if [ 22 -gt $curver ]; then
    echo "Upgrading to version 3.9.0"
    mysql -h $radhost -u $myusr_rad -p$mypsw_radius radius < sql/upgrade-3.8.0_3.9.0.sql
    mysql -h $ctshost -u $myusr_cts -p$mypsw_cts conntrack < sql/upgrade_cts-3.8.0_3.9.0.sql
  fi
fi

# create rmpoller service

if [ "$rmplr" = "1" ]; then
  echo "Creating rmpoller service"
  cp rc.d/rmpoller /etc/init.d
  chown root.root /etc/init.d/rmpoller
  chmod 755 /etc/init.d/rmpoller
fi

# create rmconntrack service

if [ "$rmctr" = "1" ]; then
  echo "Creating rmconntrack service"
  cp rc.d/rmconntrack /etc/init.d
  chown root.root /etc/init.d/rmconntrack
  chmod 755 /etc/init.d/rmconntrack
fi

# copy logrotate script

echo "Copying logrotate script"
cp etc/logrotate.d/radiusd /etc/logrotate.d/radiusd

# replace strings in cfg files for Debian

if [ "$ostype" = "2" ]; then
  sed -i 's/var\/lib\/mysql\/mysql.sock/var\/run\/mysqld\/mysqld.sock/g' /etc/radiusmanager.cfg
  sed -i 's/var\/www\/html/var\/www/g' /etc/radiusmanager.cfg
  sed -i 's/var\/www\/html/var\/www/g' /var/www/radiusmanager/config/system_cfg.php
fi

# set permission on raddb files

echo "Setting permission on raddb files"
chown $httpusr /usr/local/etc/raddb
chown $httpusr /usr/local/etc/raddb/clients.conf

# copy radiusd init script

echo "Copying radiusd init script to /etc/init.d"
if [ "$ostype" = "1" ]; then
  chmod 755 rc.d/redhat/radiusd
  cp rc.d/redhat/radiusd /etc/init.d
else
  chmod 755 rc.d/debian/radiusd
  cp rc.d/debian/radiusd /etc/init.d
fi

# finished

echo
echo "Installation finished!"
echo
