-- phpMyAdmin SQL Dump
-- version 2.11.0
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Generation Time: Mar 17, 2011 at 10:09 AM
-- Server version: 5.0.27
-- PHP Version: 5.1.6

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

--
-- Database: `radius`
--

-- --------------------------------------------------------

--
-- Table structure for table `nas`
--

DROP TABLE IF EXISTS `nas`;
CREATE TABLE `nas` (
  `id` int(10) NOT NULL auto_increment,
  `nasname` varchar(128) NOT NULL,
  `shortname` varchar(32) default NULL,
  `type` varchar(30) default 'other',
  `ports` int(5) default NULL,
  `secret` varchar(60) NOT NULL default 'secret',
  `community` varchar(50) default NULL,
  `description` varchar(200) default 'RADIUS Client',
  `starospassword` varchar(32) NOT NULL,
  `ciscobwmode` tinyint(1) NOT NULL,
  `apiusername` varchar(32) NOT NULL,
  `apipassword` varchar(32) NOT NULL,
  `enableapi` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `nasname` (`nasname`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `nas`
--

INSERT INTO `nas` (`id`, `nasname`, `shortname`, `type`, `ports`, `secret`, `community`, `description`, `starospassword`, `ciscobwmode`, `apiusername`, `apipassword`, `enableapi`) VALUES
(6, '192.168.0.8', 'Mikrotik', '0', NULL, 'testing123', NULL, '', '', 0, '', '', 0),
(18, '127.0.0.1', 'Localhost', '0', NULL, 'testing123', NULL, '', '', 0, '', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `radacct`
--

DROP TABLE IF EXISTS `radacct`;
CREATE TABLE `radacct` (
  `radacctid` bigint(21) NOT NULL auto_increment,
  `acctsessionid` varchar(64) NOT NULL default '',
  `acctuniqueid` varchar(32) NOT NULL default '',
  `username` varchar(64) NOT NULL default '',
  `groupname` varchar(64) NOT NULL default '',
  `realm` varchar(64) default '',
  `nasipaddress` varchar(15) NOT NULL default '',
  `nasportid` varchar(15) default NULL,
  `nasporttype` varchar(32) default NULL,
  `acctstarttime` datetime default NULL,
  `acctstoptime` datetime default NULL,
  `acctsessiontime` int(12) default NULL,
  `acctauthentic` varchar(32) default NULL,
  `connectinfo_start` varchar(50) default NULL,
  `connectinfo_stop` varchar(50) default NULL,
  `acctinputoctets` bigint(20) default NULL,
  `acctoutputoctets` bigint(20) default NULL,
  `calledstationid` varchar(50) NOT NULL default '',
  `callingstationid` varchar(50) NOT NULL default '',
  `acctterminatecause` varchar(32) NOT NULL default '',
  `servicetype` varchar(32) default NULL,
  `framedprotocol` varchar(32) default NULL,
  `framedipaddress` varchar(15) NOT NULL default '',
  `acctstartdelay` int(12) default NULL,
  `acctstopdelay` int(12) default NULL,
  `xascendsessionsvrkey` varchar(10) default NULL,
  `_accttime` datetime default NULL,
  `_srvid` int(11) default NULL,
  `_dailynextsrvactive` tinyint(1) default NULL,
  PRIMARY KEY  (`radacctid`),
  KEY `username` (`username`),
  KEY `framedipaddress` (`framedipaddress`),
  KEY `acctsessionid` (`acctsessionid`),
  KEY `acctsessiontime` (`acctsessiontime`),
  KEY `acctuniqueid` (`acctuniqueid`),
  KEY `acctstarttime` (`acctstarttime`),
  KEY `acctstoptime` (`acctstoptime`),
  KEY `nasipaddress` (`nasipaddress`),
  KEY `_accttime` (`_accttime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `radacct`
--


-- --------------------------------------------------------

--
-- Table structure for table `radcheck`
--

DROP TABLE IF EXISTS `radcheck`;
CREATE TABLE `radcheck` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `username` varchar(64) NOT NULL default '',
  `attribute` varchar(64) NOT NULL default '',
  `op` char(2) NOT NULL default '==',
  `value` varchar(253) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `radcheck`
--

INSERT INTO `radcheck` (`id`, `username`, `attribute`, `op`, `value`) VALUES
(4208, 'user', 'Simultaneous-Use', ':=', '10'),
(4207, 'user', 'Cleartext-Password', ':=', '1111');

-- --------------------------------------------------------

--
-- Table structure for table `radgroupcheck`
--

DROP TABLE IF EXISTS `radgroupcheck`;
CREATE TABLE `radgroupcheck` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `groupname` varchar(64) NOT NULL default '',
  `attribute` varchar(64) NOT NULL default '',
  `op` char(2) NOT NULL default '==',
  `value` varchar(253) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `groupname` (`groupname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `radgroupcheck`
--


-- --------------------------------------------------------

--
-- Table structure for table `radgroupreply`
--

DROP TABLE IF EXISTS `radgroupreply`;
CREATE TABLE `radgroupreply` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `groupname` varchar(64) NOT NULL default '',
  `attribute` varchar(64) NOT NULL default '',
  `op` char(2) NOT NULL default '=',
  `value` varchar(253) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `groupname` (`groupname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `radgroupreply`
--


-- --------------------------------------------------------

--
-- Table structure for table `radpostauth`
--

DROP TABLE IF EXISTS `radpostauth`;
CREATE TABLE `radpostauth` (
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(64) NOT NULL default '',
  `pass` varchar(64) NOT NULL default '',
  `reply` varchar(32) NOT NULL default '',
  `authdate` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `radpostauth`
--


-- --------------------------------------------------------

--
-- Table structure for table `radreply`
--

DROP TABLE IF EXISTS `radreply`;
CREATE TABLE `radreply` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `username` varchar(64) NOT NULL default '',
  `attribute` varchar(64) NOT NULL default '',
  `op` char(2) NOT NULL default '=',
  `value` varchar(253) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `radreply`
--


-- --------------------------------------------------------

--
-- Table structure for table `radusergroup`
--

DROP TABLE IF EXISTS `radusergroup`;
CREATE TABLE `radusergroup` (
  `username` varchar(64) NOT NULL default '',
  `groupname` varchar(64) NOT NULL default '',
  `priority` int(11) NOT NULL default '1',
  KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `radusergroup`
--


-- --------------------------------------------------------

--
-- Table structure for table `rm_actsrv`
--

DROP TABLE IF EXISTS `rm_actsrv`;
CREATE TABLE `rm_actsrv` (
  `id` bigint(20) NOT NULL auto_increment,
  `datetime` datetime NOT NULL,
  `username` varchar(64) NOT NULL,
  `srvid` int(11) NOT NULL,
  `dailynextsrvactive` tinyint(1) NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `datetime` (`datetime`),
  KEY `username` (`username`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_actsrv`
--


-- --------------------------------------------------------

--
-- Table structure for table `rm_allowedmanagers`
--

DROP TABLE IF EXISTS `rm_allowedmanagers`;
CREATE TABLE `rm_allowedmanagers` (
  `srvid` int(11) NOT NULL,
  `managername` varchar(64) NOT NULL,
  KEY `srvid` (`srvid`),
  KEY `managername` (`managername`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_allowedmanagers`
--

INSERT INTO `rm_allowedmanagers` (`srvid`, `managername`) VALUES
(0, 'admin'),
(0, 'manager1'),
(2, 'admin'),
(2, 'manager1'),
(1, 'admin'),
(1, 'manager1'),
(4, 'admin'),
(4, 'manager1'),
(5, 'manager1'),
(5, 'admin'),
(3, 'admin'),
(3, 'manager1'),
(16, 'manager1'),
(16, 'admin'),
(7, 'manager1'),
(7, 'admin'),
(8, 'manager1'),
(8, 'admin'),
(9, 'manager1'),
(9, 'admin'),
(10, 'admin'),
(10, 'manager1'),
(11, 'manager1'),
(11, 'admin'),
(12, 'admin'),
(12, 'manager1'),
(13, 'admin'),
(13, 'manager1'),
(14, 'admin'),
(14, 'manager1'),
(15, 'admin'),
(15, 'manager1'),
(17, 'admin'),
(17, 'manager1'),
(18, 'admin'),
(18, 'manager1'),
(19, 'manager1'),
(19, 'admin'),
(20, 'admin'),
(20, 'manager1'),
(21, 'admin'),
(21, 'manager1'),
(22, 'admin'),
(22, 'manager1'),
(23, 'admin'),
(23, 'manager1'),
(24, 'admin'),
(24, 'manager1'),
(25, 'admin'),
(25, 'manager1');

-- --------------------------------------------------------

--
-- Table structure for table `rm_allowednases`
--

DROP TABLE IF EXISTS `rm_allowednases`;
CREATE TABLE `rm_allowednases` (
  `srvid` int(11) NOT NULL,
  `nasid` int(11) NOT NULL,
  KEY `srvid` (`srvid`),
  KEY `nasid` (`nasid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_allowednases`
--

INSERT INTO `rm_allowednases` (`srvid`, `nasid`) VALUES
(0, 6),
(0, 18),
(2, 6),
(2, 18),
(1, 6),
(1, 18),
(4, 6),
(4, 18),
(5, 6),
(5, 18),
(3, 6),
(3, 18),
(16, 6),
(16, 18),
(7, 6),
(7, 18),
(8, 6),
(8, 18),
(9, 6),
(9, 18),
(10, 6),
(10, 18),
(11, 6),
(11, 18),
(12, 6),
(12, 18),
(13, 6),
(13, 18),
(14, 6),
(14, 18),
(15, 6),
(15, 18),
(17, 6),
(17, 18),
(18, 6),
(18, 18),
(19, 6),
(19, 18),
(20, 6),
(20, 18),
(21, 6),
(21, 18),
(22, 6),
(22, 18),
(23, 6),
(23, 18),
(24, 6),
(24, 18),
(25, 6),
(25, 18);

-- --------------------------------------------------------

--
-- Table structure for table `rm_cards`
--

DROP TABLE IF EXISTS `rm_cards`;
CREATE TABLE `rm_cards` (
  `id` bigint(20) NOT NULL,
  `cardnum` varchar(16) NOT NULL,
  `password` varchar(8) NOT NULL,
  `value` decimal(22,2) NOT NULL,
  `expiration` date NOT NULL,
  `series` varchar(16) NOT NULL,
  `date` date NOT NULL,
  `owner` varchar(64) NOT NULL,
  `used` datetime NOT NULL,
  `cardtype` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `downlimit` bigint(20) NOT NULL,
  `uplimit` bigint(20) NOT NULL,
  `comblimit` bigint(20) NOT NULL,
  `uptimelimit` bigint(20) NOT NULL,
  `srvid` int(11) NOT NULL,
  `transid` varchar(32) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `expiretime` bigint(20) NOT NULL,
  `timebaseexp` tinyint(1) NOT NULL,
  `timebaseonline` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `cardnum` (`cardnum`),
  KEY `series` (`series`),
  KEY `used` (`used`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_cards`
--


-- --------------------------------------------------------

--
-- Table structure for table `rm_changesrv`
--

DROP TABLE IF EXISTS `rm_changesrv`;
CREATE TABLE `rm_changesrv` (
  `id` int(11) NOT NULL auto_increment,
  `username` varchar(64) NOT NULL,
  `newsrvid` int(11) NOT NULL,
  `newsrvname` varchar(50) NOT NULL,
  `scheduledate` date NOT NULL,
  `requestdate` date NOT NULL,
  `status` tinyint(1) NOT NULL,
  `transid` varchar(32) NOT NULL,
  `requested` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `requestdate` (`requestdate`),
  KEY `scheduledate` (`scheduledate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_changesrv`
--


-- --------------------------------------------------------

--
-- Table structure for table `rm_ias`
--

DROP TABLE IF EXISTS `rm_ias`;
CREATE TABLE `rm_ias` (
  `iasid` int(11) NOT NULL auto_increment,
  `iasname` varchar(50) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `downlimit` bigint(20) NOT NULL,
  `uplimit` bigint(20) NOT NULL,
  `comblimit` bigint(20) NOT NULL,
  `uptimelimit` bigint(20) NOT NULL,
  `expiretime` bigint(20) NOT NULL,
  `timebaseonline` tinyint(1) NOT NULL,
  `timebaseexp` tinyint(1) NOT NULL,
  `srvid` int(11) NOT NULL,
  `enableias` tinyint(1) NOT NULL,
  `expiremode` tinyint(1) NOT NULL,
  `expiration` date NOT NULL,
  `simuse` int(11) NOT NULL,
  PRIMARY KEY  (`iasid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_ias`
--

INSERT INTO `rm_ias` (`iasid`, `iasname`, `price`, `downlimit`, `uplimit`, `comblimit`, `uptimelimit`, `expiretime`, `timebaseonline`, `timebaseexp`, `srvid`, `enableias`, `expiremode`, `expiration`, `simuse`) VALUES
(3, '10 hours online time', '5.00', 0, 0, 0, 10, 0, 1, 0, 14, 1, 0, '2010-12-31', 1),
(2, '500 MB', '10.00', 500, 0, 0, 0, 0, 0, 0, 15, 1, 0, '2020-12-31', 1),
(4, '2 days', '5.00', 0, 0, 0, 0, 2, 0, 2, 13, 1, 1, '0000-00-00', 1),
(10, '15 minutes online time', '1.00', 0, 0, 0, 15, 0, 0, 0, 14, 1, 0, '2020-12-31', 1);

-- --------------------------------------------------------

--
-- Table structure for table `rm_invoices`
--

DROP TABLE IF EXISTS `rm_invoices`;
CREATE TABLE `rm_invoices` (
  `id` int(11) NOT NULL auto_increment,
  `invgroup` tinyint(1) NOT NULL,
  `invnum` varchar(16) NOT NULL,
  `managername` varchar(64) NOT NULL,
  `username` varchar(64) NOT NULL,
  `date` date NOT NULL,
  `bytesdl` bigint(20) NOT NULL,
  `bytesul` bigint(20) NOT NULL,
  `bytescomb` bigint(20) NOT NULL,
  `downlimit` bigint(20) NOT NULL,
  `uplimit` bigint(20) NOT NULL,
  `comblimit` bigint(20) NOT NULL,
  `time` int(11) NOT NULL,
  `uptimelimit` bigint(20) NOT NULL,
  `days` int(6) NOT NULL,
  `expiration` date NOT NULL,
  `service` varchar(60) NOT NULL,
  `comment` varchar(200) NOT NULL,
  `transid` varchar(32) NOT NULL,
  `amount` decimal(13,2) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `zip` varchar(8) NOT NULL,
  `country` varchar(50) NOT NULL,
  `state` varchar(50) NOT NULL,
  `fullname` varchar(100) NOT NULL,
  `taxid` varchar(40) NOT NULL,
  `paymentopt` date NOT NULL,
  `invtype` tinyint(1) NOT NULL,
  `paymode` tinyint(4) NOT NULL,
  `paid` date NOT NULL,
  `price` decimal(25,6) NOT NULL,
  `tax` decimal(25,6) NOT NULL,
  `vatpercent` decimal(4,2) NOT NULL,
  `remark` varchar(400) NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `gwtransid` varchar(255) NOT NULL,
  `phone` varchar(15) NOT NULL,
  `mobile` varchar(15) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `invnum` (`invnum`),
  KEY `username` (`username`),
  KEY `managername` (`managername`),
  KEY `date` (`date`),
  KEY `gwtransid` (`gwtransid`),
  KEY `comment` (`comment`),
  KEY `paymode` (`paymode`),
  KEY `invgroup` (`invgroup`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_invoices`
--


-- --------------------------------------------------------

--
-- Table structure for table `rm_managers`
--

DROP TABLE IF EXISTS `rm_managers`;
CREATE TABLE `rm_managers` (
  `managername` varchar(64) NOT NULL,
  `password` varchar(32) NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `phone` varchar(15) NOT NULL,
  `mobile` varchar(15) NOT NULL,
  `address` varchar(50) NOT NULL,
  `city` varchar(50) NOT NULL,
  `zip` varchar(8) NOT NULL,
  `country` varchar(50) NOT NULL,
  `state` varchar(50) NOT NULL,
  `comment` varchar(200) NOT NULL,
  `company` varchar(50) NOT NULL,
  `vatid` varchar(40) NOT NULL,
  `email` varchar(50) NOT NULL,
  `balance` decimal(20,2) NOT NULL,
  `perm_listusers` tinyint(1) NOT NULL,
  `perm_createusers` tinyint(1) NOT NULL,
  `perm_editusers` tinyint(1) NOT NULL,
  `perm_edituserspriv` tinyint(1) NOT NULL,
  `perm_deleteusers` tinyint(1) NOT NULL,
  `perm_listmanagers` tinyint(1) NOT NULL,
  `perm_createmanagers` tinyint(1) NOT NULL,
  `perm_editmanagers` tinyint(1) NOT NULL,
  `perm_deletemanagers` tinyint(1) NOT NULL,
  `perm_listservices` tinyint(1) NOT NULL,
  `perm_createservices` tinyint(1) NOT NULL,
  `perm_editservices` tinyint(1) NOT NULL,
  `perm_deleteservices` tinyint(1) NOT NULL,
  `perm_listonlineusers` tinyint(1) NOT NULL,
  `perm_listinvoices` tinyint(1) NOT NULL,
  `perm_trafficreport` tinyint(1) NOT NULL,
  `perm_addcredits` tinyint(1) NOT NULL,
  `perm_negbalance` tinyint(1) NOT NULL,
  `perm_listallinvoices` tinyint(1) NOT NULL,
  `perm_logout` tinyint(1) NOT NULL,
  `perm_cardsys` tinyint(1) NOT NULL,
  `perm_editinvoice` tinyint(1) NOT NULL,
  `perm_allusers` tinyint(1) NOT NULL,
  `perm_allowdiscount` tinyint(1) NOT NULL,
  `enablemanager` tinyint(1) NOT NULL,
  PRIMARY KEY  (`managername`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_managers`
--

INSERT INTO `rm_managers` (`managername`, `password`, `firstname`, `lastname`, `phone`, `mobile`, `address`, `city`, `zip`, `country`, `state`, `comment`, `company`, `vatid`, `email`, `balance`, `perm_listusers`, `perm_createusers`, `perm_editusers`, `perm_edituserspriv`, `perm_deleteusers`, `perm_listmanagers`, `perm_createmanagers`, `perm_editmanagers`, `perm_deletemanagers`, `perm_listservices`, `perm_createservices`, `perm_editservices`, `perm_deleteservices`, `perm_listonlineusers`, `perm_listinvoices`, `perm_trafficreport`, `perm_addcredits`, `perm_negbalance`, `perm_listallinvoices`, `perm_logout`, `perm_cardsys`, `perm_editinvoice`, `perm_allusers`, `perm_allowdiscount`, `enablemanager`) VALUES
('admin', 'b59c67bf196a4758191e42f76670ceba', 'Default', 'Manager', '', '', '', '', '', '', '', 'Superuser', '', '', '', '-280.00', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
('manager1', 'b59c67bf196a4758191e42f76670ceba', 'John', 'Smith', '546-5122-5412', '594-441-4121', 'St. Anders Blvd 1654.', 'Smallville', '532321', '', 'Colorado', 'Reseller', 'My Wireless Inc.', '145121', 'john@mywirelessinc.com', '179.90', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `rm_radacct`
--

DROP TABLE IF EXISTS `rm_radacct`;
CREATE TABLE `rm_radacct` (
  `radacctid` bigint(21) NOT NULL,
  `acctuniqueid` varchar(32) NOT NULL,
  `username` varchar(64) NOT NULL,
  `acctstarttime` datetime NOT NULL,
  `acctstoptime` datetime NOT NULL,
  `acctsessiontime` int(12) NOT NULL,
  `acctsessiontimeratio` decimal(3,2) NOT NULL,
  `dlbytesstart` bigint(20) NOT NULL,
  `dlbytesstop` bigint(20) NOT NULL,
  `dlbytes` bigint(20) NOT NULL,
  `dlratio` decimal(3,2) NOT NULL,
  `ulbytesstart` bigint(20) NOT NULL,
  `ulbytesstop` bigint(20) NOT NULL,
  `ulbytes` bigint(20) NOT NULL,
  `ulratio` decimal(3,2) NOT NULL,
  PRIMARY KEY  (`radacctid`),
  KEY `acctuniqueid` (`acctuniqueid`),
  KEY `username` (`username`),
  KEY `acctstarttime` (`acctstarttime`),
  KEY `acctstoptime` (`acctstoptime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_radacct`
--


-- --------------------------------------------------------

--
-- Table structure for table `rm_services`
--

DROP TABLE IF EXISTS `rm_services`;
CREATE TABLE `rm_services` (
  `srvid` int(11) NOT NULL,
  `srvname` varchar(50) NOT NULL,
  `downrate` int(11) NOT NULL,
  `uprate` int(11) NOT NULL,
  `limitdl` tinyint(1) NOT NULL,
  `limitul` tinyint(1) NOT NULL,
  `limitcomb` tinyint(1) NOT NULL,
  `limitexpiration` tinyint(1) NOT NULL,
  `limituptime` tinyint(1) NOT NULL,
  `poolname` varchar(50) NOT NULL,
  `unitprice` decimal(25,6) NOT NULL,
  `unitpriceadd` decimal(25,6) NOT NULL,
  `timebaseexp` tinyint(1) NOT NULL,
  `timebaseonline` tinyint(1) NOT NULL,
  `timeunitexp` int(11) NOT NULL,
  `timeunitonline` int(11) NOT NULL,
  `trafficunitdl` int(11) NOT NULL,
  `trafficunitul` int(11) NOT NULL,
  `trafficunitcomb` int(11) NOT NULL,
  `inittimeexp` int(11) NOT NULL,
  `inittimeonline` int(11) NOT NULL,
  `initdl` int(11) NOT NULL,
  `initul` int(11) NOT NULL,
  `inittotal` int(11) NOT NULL,
  `srvtype` tinyint(1) NOT NULL,
  `timeaddmodeexp` tinyint(1) NOT NULL,
  `timeaddmodeonline` tinyint(1) NOT NULL,
  `trafficaddmode` tinyint(1) NOT NULL,
  `monthly` tinyint(1) NOT NULL,
  `enaddcredits` tinyint(1) NOT NULL,
  `minamount` int(20) NOT NULL,
  `minamountadd` int(20) NOT NULL,
  `resetcounters` tinyint(1) NOT NULL,
  `pricecalcdownload` tinyint(1) NOT NULL,
  `pricecalcupload` tinyint(1) NOT NULL,
  `pricecalcuptime` tinyint(1) NOT NULL,
  `unitpricetax` decimal(25,6) NOT NULL,
  `unitpriceaddtax` decimal(25,6) NOT NULL,
  `enableburst` tinyint(1) NOT NULL,
  `dlburstlimit` int(11) NOT NULL,
  `ulburstlimit` int(11) NOT NULL,
  `dlburstthreshold` int(11) NOT NULL,
  `ulburstthreshold` int(11) NOT NULL,
  `dlbursttime` int(11) NOT NULL,
  `ulbursttime` int(11) NOT NULL,
  `enableservice` int(11) NOT NULL,
  `dlquota` bigint(20) NOT NULL,
  `ulquota` bigint(20) NOT NULL,
  `combquota` bigint(20) NOT NULL,
  `timequota` bigint(20) NOT NULL,
  `priority` smallint(6) NOT NULL,
  `nextsrvid` int(11) NOT NULL,
  `dailynextsrvid` int(11) NOT NULL,
  `availucp` tinyint(1) NOT NULL,
  `renew` tinyint(1) NOT NULL,
  `policymapdl` varchar(50) NOT NULL,
  `policymapul` varchar(50) NOT NULL,
  `custattr` varchar(255) NOT NULL,
  PRIMARY KEY  (`srvid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_services`
--

INSERT INTO `rm_services` (`srvid`, `srvname`, `downrate`, `uprate`, `limitdl`, `limitul`, `limitcomb`, `limitexpiration`, `limituptime`, `poolname`, `unitprice`, `unitpriceadd`, `timebaseexp`, `timebaseonline`, `timeunitexp`, `timeunitonline`, `trafficunitdl`, `trafficunitul`, `trafficunitcomb`, `inittimeexp`, `inittimeonline`, `initdl`, `initul`, `inittotal`, `srvtype`, `timeaddmodeexp`, `timeaddmodeonline`, `trafficaddmode`, `monthly`, `enaddcredits`, `minamount`, `minamountadd`, `resetcounters`, `pricecalcdownload`, `pricecalcupload`, `pricecalcuptime`, `unitpricetax`, `unitpriceaddtax`, `enableburst`, `dlburstlimit`, `ulburstlimit`, `dlburstthreshold`, `ulburstthreshold`, `dlbursttime`, `ulbursttime`, `enableservice`, `dlquota`, `ulquota`, `combquota`, `timequota`, `priority`, `nextsrvid`, `dailynextsrvid`, `availucp`, `renew`, `policymapdl`, `policymapul`, `custattr`) VALUES
(0, 'Default service', 524288, 131072, 0, 0, 0, 0, 0, '', '1.000000', '0.000000', 2, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, '0.190000', '0.000000', 0, 1048576, 1048576, 1048576, 1048576, 10, 10, 1, 0, 0, 0, 0, 4, -1, -1, 0, 0, '512', '128', ''),
(2, 'Card download limit 128 k', 131072, 131072, 1, 0, 0, 1, 0, '', '0.000000', '0.000000', 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(1, 'Access list - Mikrotik', 0, 0, 0, 0, 0, 0, 0, '', '0.000000', '0.000000', 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(4, 'Prepaid MB dl+ul', 393216, 131072, 0, 0, 1, 0, 0, '', '1.000000', '0.000000', 2, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, '0.190000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 3, -1, -1, 1, 0, '', '', ''),
(5, 'Prepaid monthly 1 GB download', 786432, 262144, 1, 0, 0, 1, 0, '', '29.411765', '0.084034', 3, 0, 1, 0, 1000, 0, 0, 1, 0, 1000, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, '5.588235', '0.015966', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 1, 1, '', '', ''),
(3, 'Postpaid MB download', 524288, 131072, 0, 0, 0, 0, 0, '', '0.084034', '0.000000', 2, 1, 0, 1, 1, 0, 0, 0, 1, 50, 0, 0, 2, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, '0.015966', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 1, '', '', ''),
(16, 'Prepaid MB', 262144, 131072, 1, 0, 0, 0, 0, '', '0.084034', '0.840336', 3, 0, 0, 0, 1, 0, 0, 0, 0, 50, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, '0.015966', '0.159664', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 1, 0, '', '', ''),
(7, 'Prepaid monthly flat + quotas', 0, 0, 0, 0, 0, 1, 0, '', '40.000000', '0.000000', 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, '7.600000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 104857600, 0, 0, 7200, 8, -1, -1, 1, 0, '', '', ''),
(8, 'Postpaid online time', 0, 0, 0, 0, 0, 0, 0, '', '0.991597', '0.000000', 2, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, '0.188403', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(9, 'Postpaid monthly flat', 1048576, 524288, 0, 0, 0, 0, 0, '', '20.000000', '0.000000', 3, 0, 1, 1, 0, 0, 0, 1, 4, 1, 2, 3, 2, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, '3.800000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 1, '', '', ''),
(10, 'Postpaid monthly flat + quotas', 0, 0, 0, 0, 0, 0, 0, '', '15.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, '2.850000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 10000000, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(11, 'Expired', 2097152, 524288, 0, 0, 0, 0, 0, 'expired', '0.000000', '0.000000', 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(12, 'Access list - StarOS', 0, 0, 0, 0, 0, 0, 0, '', '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(13, 'IAS expiration limit', 0, 0, 0, 0, 0, 1, 0, '', '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(14, 'IAS uptime limit', 0, 0, 0, 0, 0, 0, 1, '', '0.000000', '0.000000', 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(15, 'IAS download limit', 0, 0, 1, 0, 0, 0, 0, '', '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(17, 'Prepaid expiration & online time', 1048576, 131072, 0, 0, 0, 1, 1, '', '10.000000', '0.000000', 3, 0, 1, 30, 0, 0, 0, 1, 30, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, '1.900000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 1, 0, '', '', ''),
(18, 'Email only', 0, 0, 0, 0, 0, 0, 0, '', '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(19, 'Prepaid monthly', 262144, 131072, 0, 0, 0, 1, 0, '', '10.000000', '0.100000', 3, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, '1.900000', '0.019000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 1, 1, '', '', ''),
(20, 'Card expiration + uptime limit', 524288, 131072, 0, 0, 0, 1, 1, '', '0.000000', '0.000000', 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(21, 'Prepaid online time', 131072, 131072, 0, 0, 0, 0, 1, '', '0.100000', '0.000000', 3, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, '0.019000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 1, 0, '', '', ''),
(22, 'Card online time limit', 524288, 131072, 0, 0, 0, 0, 1, '', '0.000000', '0.000000', 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(23, 'Card expiration limit', 524288, 131072, 0, 0, 0, 1, 0, '', '0.000000', '0.000000', 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, '0.000000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(24, 'Postpaid traffic', 524288, 262144, 0, 0, 0, 0, 0, '', '1.000000', '0.000000', 2, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, '0.190000', '0.000000', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 0, '', '', ''),
(25, 'Postpaid monthly 100 MB + overquotas', 524288, 131072, 0, 0, 0, 0, 0, '', '20.000000', '0.084034', 3, 0, 1, 0, 100, 100, 0, 1, 0, 100, 100, 0, 2, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, '3.800000', '0.015966', 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 8, -1, -1, 0, 1, '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `rm_settings`
--

DROP TABLE IF EXISTS `rm_settings`;
CREATE TABLE `rm_settings` (
  `currency` varchar(15) NOT NULL,
  `unixacc` tinyint(1) NOT NULL,
  `diskquota` tinyint(1) NOT NULL,
  `quotatpl` varchar(30) NOT NULL,
  `paymentopt` int(11) NOT NULL,
  `changesrv` tinyint(1) NOT NULL,
  `vatpercent` decimal(4,2) NOT NULL,
  `disablenotpaid` tinyint(1) NOT NULL,
  `resetctr` tinyint(1) NOT NULL,
  `lang` varchar(20) NOT NULL,
  `disconnmethod` tinyint(1) NOT NULL,
  `warndl` bigint(20) NOT NULL,
  `warndlpercent` int(3) NOT NULL,
  `warnul` bigint(20) NOT NULL,
  `warnulpercent` int(3) NOT NULL,
  `warncomb` bigint(20) NOT NULL,
  `warncombpercent` int(3) NOT NULL,
  `warnuptime` bigint(20) NOT NULL,
  `warnuptimepercent` int(3) NOT NULL,
  `warnexpiry` int(11) NOT NULL,
  `emailwarning` tinyint(1) NOT NULL,
  `warnmode` tinyint(1) NOT NULL,
  `emailnotify` tinyint(1) NOT NULL,
  `selfreg` tinyint(1) NOT NULL,
  `edituserdata` tinyint(1) NOT NULL,
  `hidelimits` tinyint(1) NOT NULL,
  `pm_internal` tinyint(1) NOT NULL,
  `pm_paypalstd` tinyint(1) NOT NULL,
  `pm_paypalpro` tinyint(1) NOT NULL,
  `pm_paypalexp` tinyint(1) NOT NULL,
  `pm_netcash` tinyint(1) NOT NULL,
  `pm_authorizenet` tinyint(1) NOT NULL,
  `pm_dps` tinyint(1) NOT NULL,
  `pm_2co` tinyint(1) NOT NULL,
  `unixhost` tinyint(1) NOT NULL,
  `remotehostname` varchar(100) NOT NULL,
  `maclock` tinyint(1) NOT NULL,
  `billingstart` tinyint(2) NOT NULL,
  `renewday` tinyint(2) NOT NULL,
  `changepswucp` tinyint(1) NOT NULL,
  `redeemucp` tinyint(1) NOT NULL,
  `buycreditsucp` tinyint(1) NOT NULL,
  `selfreg_firstname` tinyint(1) NOT NULL,
  `selfreg_lastname` tinyint(1) NOT NULL,
  `selfreg_address` tinyint(1) NOT NULL,
  `selfreg_city` tinyint(1) NOT NULL,
  `selfreg_zip` tinyint(1) NOT NULL,
  `selfreg_country` tinyint(1) NOT NULL,
  `selfreg_state` tinyint(1) NOT NULL,
  `selfreg_phone` tinyint(1) NOT NULL,
  `selfreg_mobile` tinyint(1) NOT NULL,
  `selfreg_email` tinyint(1) NOT NULL,
  `selfreg_verify` tinyint(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_settings`
--

INSERT INTO `rm_settings` (`currency`, `unixacc`, `diskquota`, `quotatpl`, `paymentopt`, `changesrv`, `vatpercent`, `disablenotpaid`, `resetctr`, `lang`, `disconnmethod`, `warndl`, `warndlpercent`, `warnul`, `warnulpercent`, `warncomb`, `warncombpercent`, `warnuptime`, `warnuptimepercent`, `warnexpiry`, `emailwarning`, `warnmode`, `emailnotify`, `selfreg`, `edituserdata`, `hidelimits`, `pm_internal`, `pm_paypalstd`, `pm_paypalpro`, `pm_paypalexp`, `pm_netcash`, `pm_authorizenet`, `pm_dps`, `pm_2co`, `unixhost`, `remotehostname`, `maclock`, `billingstart`, `renewday`, `changepswucp`, `redeemucp`, `buycreditsucp`, `selfreg_firstname`, `selfreg_lastname`, `selfreg_address`, `selfreg_city`, `selfreg_zip`, `selfreg_country`, `selfreg_state`, `selfreg_phone`, `selfreg_mobile`, `selfreg_email`, `selfreg_verify`) VALUES
('USD', 0, 0, 'template', 14, 1, '19.00', 1, 1, 'English', 0, 10, 0, 10, 0, 10, 0, 3600, 0, 5, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, '127.0.0.1', 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `rm_specperacnt`
--

DROP TABLE IF EXISTS `rm_specperacnt`;
CREATE TABLE `rm_specperacnt` (
  `id` int(11) NOT NULL auto_increment,
  `srvid` int(11) NOT NULL,
  `starttime` time NOT NULL,
  `endtime` time NOT NULL,
  `timeratio` decimal(3,2) NOT NULL,
  `dlratio` decimal(3,2) NOT NULL,
  `ulratio` decimal(3,2) NOT NULL,
  `connallowed` tinyint(1) NOT NULL,
  `mon` tinyint(1) NOT NULL,
  `tue` tinyint(1) NOT NULL,
  `wed` tinyint(1) NOT NULL,
  `thu` tinyint(1) NOT NULL,
  `fri` tinyint(1) NOT NULL,
  `sat` tinyint(1) NOT NULL,
  `sun` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `srvid` (`srvid`),
  KEY `fromtime` (`starttime`),
  KEY `totime` (`endtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_specperacnt`
--

INSERT INTO `rm_specperacnt` (`id`, `srvid`, `starttime`, `endtime`, `timeratio`, `dlratio`, `ulratio`, `connallowed`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat`, `sun`) VALUES
(1, 16, '00:00:00', '18:59:09', '0.50', '0.50', '0.50', 1, 1, 1, 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `rm_specperbw`
--

DROP TABLE IF EXISTS `rm_specperbw`;
CREATE TABLE `rm_specperbw` (
  `id` int(11) NOT NULL auto_increment,
  `srvid` int(11) NOT NULL,
  `starttime` time NOT NULL,
  `endtime` time NOT NULL,
  `dlrate` int(11) NOT NULL,
  `ulrate` int(11) NOT NULL,
  `dlburstlimit` int(11) NOT NULL,
  `ulburstlimit` int(11) NOT NULL,
  `dlburstthreshold` int(11) NOT NULL,
  `ulburstthreshold` int(11) NOT NULL,
  `dlbursttime` int(11) NOT NULL,
  `ulbursttime` int(11) NOT NULL,
  `enableburst` tinyint(1) NOT NULL,
  `priority` int(11) NOT NULL,
  `mon` tinyint(1) NOT NULL,
  `tue` tinyint(1) NOT NULL,
  `wed` tinyint(1) NOT NULL,
  `thu` tinyint(1) NOT NULL,
  `fri` tinyint(1) NOT NULL,
  `sat` tinyint(1) NOT NULL,
  `sun` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_specperbw`
--

INSERT INTO `rm_specperbw` (`id`, `srvid`, `starttime`, `endtime`, `dlrate`, `ulrate`, `dlburstlimit`, `ulburstlimit`, `dlburstthreshold`, `ulburstthreshold`, `dlbursttime`, `ulbursttime`, `enableburst`, `priority`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat`, `sun`) VALUES
(1, 16, '00:00:00', '03:59:09', 1048576, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `rm_syslog`
--

DROP TABLE IF EXISTS `rm_syslog`;
CREATE TABLE `rm_syslog` (
  `id` int(11) NOT NULL auto_increment,
  `datetime` datetime NOT NULL,
  `ip` varchar(15) NOT NULL,
  `name` varchar(64) NOT NULL,
  `eventid` int(11) NOT NULL,
  `data1` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_syslog`
--


-- --------------------------------------------------------

--
-- Table structure for table `rm_usergroups`
--

DROP TABLE IF EXISTS `rm_usergroups`;
CREATE TABLE `rm_usergroups` (
  `groupid` int(11) NOT NULL auto_increment,
  `groupname` varchar(50) NOT NULL,
  `descr` varchar(200) NOT NULL,
  PRIMARY KEY  (`groupid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_usergroups`
--

INSERT INTO `rm_usergroups` (`groupid`, `groupname`, `descr`) VALUES
(1, 'Default group', '');

-- --------------------------------------------------------

--
-- Table structure for table `rm_users`
--

DROP TABLE IF EXISTS `rm_users`;
CREATE TABLE `rm_users` (
  `username` varchar(64) NOT NULL,
  `password` varchar(32) NOT NULL,
  `groupid` int(11) NOT NULL,
  `enableuser` tinyint(1) NOT NULL,
  `uplimit` bigint(20) NOT NULL,
  `downlimit` bigint(20) NOT NULL,
  `comblimit` bigint(20) NOT NULL,
  `firstname` varchar(50) NOT NULL,
  `lastname` varchar(50) NOT NULL,
  `company` varchar(50) NOT NULL,
  `phone` varchar(15) NOT NULL,
  `mobile` varchar(15) NOT NULL,
  `address` varchar(100) NOT NULL,
  `city` varchar(50) NOT NULL,
  `zip` varchar(8) NOT NULL,
  `country` varchar(50) NOT NULL,
  `state` varchar(50) NOT NULL,
  `comment` varchar(200) NOT NULL,
  `mac` varchar(17) NOT NULL,
  `usemacauth` tinyint(1) NOT NULL,
  `expiration` datetime NOT NULL,
  `uptimelimit` bigint(20) NOT NULL,
  `srvid` int(11) NOT NULL,
  `staticip` varchar(15) NOT NULL,
  `usestaticip` tinyint(1) NOT NULL,
  `createdon` date NOT NULL,
  `acctype` tinyint(1) NOT NULL,
  `credits` decimal(20,2) NOT NULL,
  `cardfails` tinyint(4) NOT NULL,
  `createdby` varchar(64) NOT NULL,
  `owner` varchar(64) NOT NULL,
  `taxid` varchar(40) NOT NULL,
  `email` varchar(50) NOT NULL,
  `maccm` varchar(17) NOT NULL,
  `custattr` varchar(255) NOT NULL,
  `warningsent` tinyint(1) NOT NULL,
  `verifycode` varchar(10) NOT NULL,
  `verified` tinyint(1) NOT NULL,
  `selfreg` tinyint(1) NOT NULL,
  `verifyfails` tinyint(4) NOT NULL,
  `verifysentnum` tinyint(4) NOT NULL,
  `verifymobile` varchar(15) NOT NULL,
  PRIMARY KEY  (`username`),
  KEY `srvid` (`srvid`),
  KEY `groupid` (`groupid`),
  KEY `enableuser` (`enableuser`),
  KEY `firstname` (`firstname`),
  KEY `lastname` (`lastname`),
  KEY `company` (`company`),
  KEY `phone` (`phone`),
  KEY `mobile` (`mobile`),
  KEY `address` (`address`),
  KEY `city` (`city`),
  KEY `zip` (`zip`),
  KEY `country` (`country`),
  KEY `state` (`state`),
  KEY `comment` (`comment`),
  KEY `mac` (`mac`),
  KEY `staticip` (`staticip`),
  KEY `acctype` (`acctype`),
  KEY `email` (`email`),
  KEY `maccm` (`maccm`),
  KEY `owner` (`owner`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `rm_users`
--

INSERT INTO `rm_users` (`username`, `password`, `groupid`, `enableuser`, `uplimit`, `downlimit`, `comblimit`, `firstname`, `lastname`, `company`, `phone`, `mobile`, `address`, `city`, `zip`, `country`, `state`, `comment`, `mac`, `usemacauth`, `expiration`, `uptimelimit`, `srvid`, `staticip`, `usestaticip`, `createdon`, `acctype`, `credits`, `cardfails`, `createdby`, `owner`, `taxid`, `email`, `maccm`, `custattr`, `warningsent`, `verifycode`, `verified`, `selfreg`, `verifyfails`, `verifysentnum`, `verifymobile`) VALUES
('user', 'b59c67bf196a4758191e42f76670ceba', 1, 1, 0, 209715200, 0, 'John', 'Smith', 'R&amp;C company', '158182817', '', 'West road 1343.', 'Tampa', '32434', '', 'California', '', '11:22:33:44:55:66', 0, '2012-12-31 00:00:00', 129, 16, '', 0, '2010-02-15', 0, '975.00', 0, 'admin', 'admin', '', 'user@myisp.com', '', '', 0, '', 0, 0, 0, 0, '');
