ALTER TABLE `radcheck` DROP INDEX `UserName` ,
ADD INDEX `UserName` ( `UserName` ) ;
ALTER TABLE `radgroupcheck` DROP INDEX `GroupName` ,
ADD INDEX `GroupName` ( `GroupName` ) ;
ALTER TABLE `radgroupreply` DROP INDEX `GroupName` ,
ADD INDEX `GroupName` ( `GroupName` ) ;
ALTER TABLE `radreply` DROP INDEX `UserName` ,
ADD INDEX `UserName` ( `UserName` ) ;
ALTER TABLE `usergroup` DROP INDEX `UserName` ,
ADD INDEX `UserName` ( `UserName` ) ;

ALTER TABLE `rm_changesrv` CHANGE `username` `username` VARCHAR( 64 ) NOT NULL ;

CREATE TABLE `rm_ias` (
  `iasid` int(11) NOT NULL auto_increment,
  `iasname` varchar(40) NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `availdl` bigint(20) NOT NULL,
  `availul` bigint(20) NOT NULL,
  `availtotal` bigint(20) NOT NULL,
  `availuptime` bigint(20) NOT NULL,
  `timeamount` int(11) NOT NULL,
  `timeunit` tinyint(1) NOT NULL,
  `srvid` int(11) NOT NULL,
  `enableias` tinyint(1) NOT NULL,
  `expiremode` tinyint(1) NOT NULL,
  `validity` date NOT NULL,
  PRIMARY KEY  (`iasid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `rm_syslog` (
  `id` int(11) NOT NULL auto_increment,
  `datetime` datetime NOT NULL,
  `ip` varchar(15) NOT NULL,
  `name` varchar(64) NOT NULL,
  `eventid` int(11) NOT NULL,
  `data1` varchar(64) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `rm_invoices` CHANGE `username` `username` VARCHAR( 64 ) NOT NULL ;
ALTER TABLE `rm_invoices` CHANGE `transid` `transid` VARCHAR( 32 ) NOT NULL ;
ALTER TABLE `rm_invoices` ADD `country` VARCHAR( 50 ) NOT NULL AFTER `zip` ;
ALTER TABLE `rm_invoices` ADD `state` VARCHAR( 50 ) NOT NULL AFTER `country` ;
ALTER TABLE `rm_invoices` CHANGE `fullname` `fullname` VARCHAR( 50 ) NOT NULL ;
ALTER TABLE `rm_invoices` ADD `gwtransid` VARCHAR( 255 ) NOT NULL AFTER `balance` ;

ALTER TABLE `rm_services` ADD `nextsrvid` INT( 11 ) NOT NULL DEFAULT '-1' AFTER `priority` ;
ALTER TABLE `rm_services` ADD `availucp` TINYINT( 1 ) NOT NULL AFTER `nextsrvid` ;

ALTER TABLE `rm_settings` ADD `selfreg` TINYINT( 1 ) NOT NULL AFTER `emailwarning` ;
ALTER TABLE `rm_settings` ADD `edituserdata` TINYINT( 1 ) NOT NULL AFTER `selfreg` ;
ALTER TABLE `rm_settings` ADD `exchange` DECIMAL( 20, 10 ) NOT NULL ;
ALTER TABLE `rm_settings` ADD `hidelimits` TINYINT( 1 ) NOT NULL AFTER `exchange` ;

ALTER TABLE `rm_users` CHANGE `fullname` `firstname` VARCHAR( 30 ) NOT NULL ;
ALTER TABLE `rm_users` ADD `lastname` VARCHAR( 30 ) NOT NULL AFTER `firstname` ;
ALTER TABLE `rm_users` ADD `company` VARCHAR( 30 ) NOT NULL AFTER `lastname` ;
ALTER TABLE `rm_users` CHANGE `address` `address` VARCHAR( 70 ) NOT NULL ;
ALTER TABLE `rm_users` ADD `country` VARCHAR( 50 ) NOT NULL AFTER `zip` ;
ALTER TABLE `rm_users` ADD `state` VARCHAR( 50 ) NOT NULL AFTER `country` ;

UPDATE rm_users SET lastname = SUBSTRING_INDEX(firstname, ' ', 1) WHERE lastname = "" ;
UPDATE rm_users SET firstname = SUBSTRING_INDEX(firstname, ' ', -1) ;
