<?php
/*****************************************************************************/
/**        Name: api_verifyuser                                       	    **/
/** Description: This function is called upon self registering the user,    **/
/**		 right after submitting the form. From this function	    **/
/**		 You can call your own SMS gateway (HTTP gateway with CURL  **/
/**              or a shell script to use your own mobile phone) to send    **/
/**		 the verification code for the user.			    **/
/**		 The function includes an example of integrating the 	    **/
/**		 clickatell.com HTTP -> SMS gateway.			    **/
/**       Input: username - RADIUS user name                                **/
/**		 password - RADIUS password                                 **/
/**		 firstname - first name of user                             **/
/**		 lastname - last name of user                               **/
/**		 address - postal address of user                           **/
/**		 city - city of user                                        **/
/**		 zip - zip code of user                                     **/
/**		 country - country of user                                  **/
/**		 state - state of user                                      **/
/**		 phone - phone number of user                               **/
/**		 mobile - mobile number of user                             **/
/**		 email - email address of user                              **/
/**		 srvid - associated service id			            **/
/**		 verifycode - the verification code to send                 **/
/**		 errmsg - pointer to error message returned by the gateway  **/
/**      Output: true - API succeeded					    **/
/**      	 false - API error					    **/
/*****************************************************************************/
function api_verifyuser($username, $password, $firstname, $lastname, $address, $city, $zip, $country, $state, $phone, $mobile, $email, $srvid, $verifycode, &$errmsg)
{
  // return success for testing (comment out this in real environments)

//  return true;

  // enter your clickatell.com credentials here

  $api_user = "clickatell_username";
  $api_password = "clickatell_password";
  $api_id = "clickatell_api_id";

  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, "http://api.clickatell.com/http/sendmsg?user=$api_user&password=$api_password&api_id=$api_id&to=$mobile&text=$verifycode");
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
  $res = curl_exec($ch);
  curl_close($ch);

  // uncomment this to see the result from clickatell.com HTTP gateway

//  print $res;

  if (substr($res, 0 , 4) ==  "ERR:")
  {
    $errmsg = $res;
    return false;
  }

  return true;
}
?>
