#!/bin/sh 
#
## Set your IP address
##MYIP=""
#
## Flush rules & reset counters
iptables -F
iptables -Z
iptables -X
iptables -t nat -F
iptables -t nat -Z
iptables -t nat -X
#
## Set policies
iptables -P INPUT ACCEPT
iptables -P FORWARD ACCEPT
iptables -P OUTPUT ACCEPT
#
## Pass all locally-originating packets
iptables -A INPUT -i lo -j ACCEPT
iptables -A OUTPUT -o lo -j ACCEPT
#
## Allow transparence proxy
#iptables -t nat -A PREROUTING -p tcp --dport 80 -j REDIRECT --to-port 3128
#
## Accept ICMP ping echo requests
## (this allows other people to ping your machine, among other things),
iptables -A INPUT -p icmp --icmp-type echo-request -j ACCEPT
iptables -t nat -A POSTROUTING -s 192.168.120.0/24  -j MASQUERADE
iptables -t nat -A POSTROUTING -s 192.168.121.0/24  -j MASQUERADE
iptables -t nat -A POSTROUTING -s 192.168.122.0/24  -j MASQUERADE
iptables -t nat -A POSTROUTING -s 192.168.123.0/24  -j MASQUERADE
#
iptables -A FORWARD -p tcp -s 192.168.120.0/24 --dport 25 -j REJECT
iptables -A FORWARD -p tcp -s 192.168.121.0/24 --dport 25 -j REJECT
iptables -A FORWARD -p tcp -s 192.168.122.0/24 --dport 25 -j REJECT
iptables -A FORWARD -p tcp -s 192.168.123.0/24 --dport 25 -j REJECT
## Accept all traffic from a specific machine with IP x.x.x.x
## replace x.x.x.x with the desired IP, then uncomment the line.
#iptables -A INPUT -p tcp -m tcp --syn -s xxx.xxx.xxx.xxx -j ACCEPT
#
## Accept traffic on port p from a specific machine with IP x.x.x.x
## replace p with the desired port number, and replace x.x.x.x with
## the desired IP, then uncomment the line.
#iptables -A INPUT -p tcp -m tcp --syn -s x.x.x.x --dport p -j ACCEPT
#
## Accept ssh (port 22)
iptables -A INPUT -p tcp --dport 22 -j ACCEPT
iptables -A INPUT -p tcp --dport 1212 -j ACCEPT
#
## Accept http (port 80)
iptables -A INPUT -p tcp -m tcp --syn --dport 80:81 -j ACCEPT
## Accept inbound identd (port 113)
#iptables -A INPUT -p tcp -m tcp --syn --dport 113 -j ACCEPT
## or you can reject and send back a TCP RST packet instead
#iptables -A INPUT -p tcp -m tcp --dport 113 -j REJECT --reject-with tcp-reset
#
## Accept imap (port 143)
#iptables -A INPUT -p tcp -m tcp --syn --dport 143 -j ACCEPT
#
## Accept https (port 443)
#iptables -A INPUT -p tcp -m tcp --syn --dport 443 -j ACCEPT
#radius server
iptables -A INPUT -p udp --dport 1812 -j ACCEPT
iptables -A INPUT -p udp --dport 1813 -j ACCEPT
## Accept vpn udp 53 tcp:443 PPTP-tcp:1723 L2TP-udp:1701 and gre 
iptables -A INPUT -p tcp -m tcp --syn  --dport 443 -j ACCEPT
iptables -A INPUT -p udp --dport 53 -j ACCEPT
iptables -A INPUT -p udp --dport 1701 -j ACCEPT
iptables -A INPUT -p tcp --dport 1723 -j ACCEPT
iptables -A INPUT -p gre -j ACCEPT
iptables -A INPUT -p udp --dport 500 -j ACCEPT
iptables -A INPUT -p udp --dport 4500 -j ACCEPT
iptables -A INPUT -p esp -j ACCEPT
iptables -I INPUT -p tcp --dport 10249 -j ACCEPT
iptables -I INPUT -p tcp --dport 10248 -j ACCEPT
iptables -I INPUT -p tcp --dport 10028 -j ACCEPT
iptables -I INPUT -p tcp --dport 20001:20254 -j ACCEPT
iptables -I INPUT -p tcp --dport 30001:30254 -j ACCEPT
iptables -I INPUT -p tcp --dport 13128 -j ACCEPT
iptables -I INPUT -p tcp --dport 23128 -j ACCEPT
iptables -I INPUT -p tcp --dport 33128 -j ACCEPT
iptables -I INPUT -p tcp --dport 8888 -j ACCEPT
iptables -I INPUT -p tcp --dport 9999 -j ACCEPT
iptables -I OUTPUT -p tcp --dport 3389 -j DROP
iptables -I OUTPUT -p tcp --dport 22 -j DROP
iptables -I INPUT -p tcp --dport 9085 -j ACCEPT
iptables -I INPUT -p tcp --dport 9088 -j ACCEPT
iptables -I INPUT -p udp -j ACCEPT
#
## Accept smtps (port 465)
#iptables -A INPUT -p tcp -m tcp --syn --dport 465 -j ACCEPT
#
## Accept imaps (port 993)
#iptables -A INPUT -p tcp -m tcp --syn --dport 993 -j ACCEPT
#
## Accept pop3s (port 995)
#iptables -A INPUT -p tcp -m tcp --syn --dport 995 -j ACCEPT
#
## Allow inbound established and related outside communication
iptables -A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT
#
## Drop outside initiated connections
iptables -A INPUT -m state --state NEW -j ACCEPT
#
## Allow all outbound tcp, udp, icmp traffic with state
iptables -A OUTPUT -p esp -j ACCEPT
iptables -A OUTPUT -p gre -j ACCEPT
iptables -A OUTPUT -p tcp -m state --state NEW,ESTABLISHED -j ACCEPT
iptables -A OUTPUT -p udp -m state --state NEW,ESTABLISHED -j ACCEPT
iptables -A OUTPUT -p icmp -m state --state NEW,ESTABLISHED,RELATED -j ACCEPT
#
## Save rules
service iptables save
#
#
echo "iptables configuration is complete"
echo ""
echo "Check your rules - iptables -L -n"
echo ""

