
## Accept ssh (port 22)
iptables -A INPUT -p tcp --dport 22 -j ACCEPT
iptables -A INPUT -p tcp --dport 1212 -j ACCEPT
#
## Accept all udp
iptables -A INPUT -p udp -j ACCEPT
#
## Accept http (port 80)
iptables -A INPUT -p tcp -m tcp --syn --dport 80:81 -j ACCEPT
## Accept inbound identd (port 113)
#iptables -A INPUT -p tcp -m tcp --syn --dport 113 -j ACCEPT
## or you can reject and send back a TCP RST packet instead
#iptables -A INPUT -p tcp -m tcp --dport 113 -j REJECT --reject-with tcp-reset
#
## Accept imap (port 143)
#iptables -A INPUT -p tcp -m tcp --syn --dport 143 -j ACCEPT
#
## Accept https (port 443)
#iptables -A INPUT -p tcp -m tcp --syn --dport 443 -j ACCEPT
#radius server
iptables -A INPUT -p udp --dport 1812 -j ACCEPT
iptables -A INPUT -p udp --dport 1813 -j ACCEPT
## Accept vpn udp 53 tcp:443 PPTP-tcp:1723 L2TP-udp:1701 and gre 
##iptables -A INPUT -p tcp -m tcp --syn  --dport 443 -j ACCEPT
##iptables -A INPUT -p udp --dport 53 -j ACCEPT
iptables -A INPUT -p tcp -m tcp --syn  --dport 9001 -j ACCEPT
iptables -A INPUT -p udp --dport 9001 -j ACCEPT
##iptables -t nat -A PREROUTING -p tcp --dport 9001 -j REDIRECT --to-port 443 
##iptables -t nat -A PREROUTING -p udp --dport 9001 -j REDIRECT --to-port 53

iptables -A INPUT -p udp --dport 1701 -j ACCEPT
iptables -A INPUT -p tcp --dport 1723 -j ACCEPT
iptables -A INPUT -p gre -j ACCEPT
iptables -A INPUT -p udp --dport 500 -j ACCEPT
iptables -A INPUT -p udp --dport 4500 -j ACCEPT
iptables -A INPUT -p esp -j ACCEPT
iptables -I INPUT -p tcp --dport 10249 -j ACCEPT
iptables -I INPUT -p tcp --dport 10248 -j ACCEPT
iptables -I INPUT -p tcp --dport 20001:20254 -j ACCEPT
iptables -I INPUT -p tcp --dport 30001:30254 -j ACCEPT
iptables -I INPUT -p tcp --dport 13128 -j ACCEPT
iptables -I INPUT -p tcp --dport 10028 -j ACCEPT
iptables -I INPUT -p tcp --dport 22111 -j ACCEPT
iptables -I INPUT -p tcp --dport 23128 -j ACCEPT
iptables -I INPUT -p tcp --dport 33128 -j ACCEPT
iptables -I INPUT -p tcp --dport 8888 -j ACCEPT
iptables -I INPUT -p tcp --dport 9999 -j ACCEPT
iptables -I OUTPUT -p tcp --dport 3389 -j DROP
iptables -I OUTPUT -p tcp --dport 22 -j DROP
iptables -I INPUT -p tcp --dport 9085 -j ACCEPT
iptables -I INPUT -p tcp --dport 9088 -j ACCEPT
iptables -I INPUT -p tcp --dport 81 -j ACCEPT
iptables -I INPUT -p tcp --dport 9191 -j ACCEPT
iptables -I INPUT -p tcp --dport 8181 -j ACCEPT
iptables -I INPUT -p tcp --dport 7070 -j ACCEPT
iptables -I INPUT -p udp --dport 9191 -j ACCEPT
iptables -I INPUT -p tcp --dport 3128 -j ACCEPT
iptables -I INPUT -p udp --dport 3128 -j ACCEPT
iptables -I INPUT -p udp --dport 8181 -j ACCEPT
iptables -I INPUT -p udp --dport 7070 -j ACCEPT
iptables -I INPUT -p udp --dport 6666 -j ACCEPT
iptables -I INPUT -p tcp --dport 6666 -j ACCEPT
iptables -I INPUT -p udp --dport 40249 -j ACCEPT
iptables -I INPUT -p tcp --dport 40249 -j ACCEPT
iptables -I INPUT -p udp --dport 43808 -j ACCEPT
iptables -I INPUT -p tcp --dport 43808 -j ACCEPT
iptables -I INPUT -p udp -j ACCEPT
#
## Accept smtps (port 465)
#iptables -A INPUT -p tcp -m tcp --syn --dport 465 -j ACCEPT
#
## Accept imaps (port 993)
#iptables -A INPUT -p tcp -m tcp --syn --dport 993 -j ACCEPT
#
## Accept pop3s (port 995)
#iptables -A INPUT -p tcp -m tcp --syn --dport 995 -j ACCEPT
#
## Allow inbound established and related outside communication
iptables -A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT
#
## Drop outside initiated connections
iptables -A INPUT -m state --state NEW -j ACCEPT
#
## Allow all outbound tcp, udp, icmp traffic with state
iptables -A OUTPUT -p esp -j ACCEPT
iptables -A OUTPUT -p gre -j ACCEPT
iptables -A OUTPUT -p tcp -m state --state NEW,ESTABLISHED -j ACCEPT
iptables -A OUTPUT -p udp -m state --state NEW,ESTABLISHED -j ACCEPT
iptables -A OUTPUT -p icmp -m state --state NEW,ESTABLISHED,RELATED -j ACCEPT
#
## Save rules
service iptables save
#
#
echo "iptables configuration is complete"
echo ""
echo "Check your rules - iptables -L -n"
echo ""

