#!/bin/bash
####################################################
# author:hai								   #
# date  :2012-11-24                                #
# setup openvpn pptpd l2tpd to centos7             #
####################################################
#PPTP:172.20.1.2-172.20.255.254
#L2TP:172.21.1.2-172.21.255.254
#OPENVPN-TCP:172.22.1.2-172.22.255.254

if [ $(id -u) != "0" ]; then
    printf "Error: You must be root to run this tool!\n"
    exit 1
fi

#工作目录
WORKPATH=`pwd`

ReadIni() {
    file=$1;section=$2;item=$3;
    val=$(awk -F '=' '/\['${section}'\]/{a=1} (a==1 && "'${item}'"==$1){a=0;print $2}' ${file}) 
    echo ${val}
}

##open IP forward
echo 1 > /proc/sys/net/ipv4/ip_forward
if [ `cat /usr/lib/sysctl.d/50-default.conf | grep ip_forward | wc -l` -eq 0 ]
then
	echo "net.ipv4.ip_forward = 1" >> /usr/lib/sysctl.d/50-default.conf
	echo "net.netfilter.nf_conntrack_tcp_timeout_established = 1200" >> /usr/lib/sysctl.d/50-default.conf
	echo "net.netfilter.nf_conntrack_max = 1255350" >> /usr/lib/sysctl.d/50-default.conf
fi
/sbin/sysctl -p /usr/lib/sysctl.d/50-default.conf

#禁用firewalld服务
systemctl stop firewalld
systemctl mask firewalld

yum clean all
yum -y install epel-release
yum -y install psmisc ntp ntpdate dos2unix wget unzip openssh-clients dkms libpcap-devel ppp rp-pppoe pkcs11-helper-devel openssl-devel ocserv iptables* git make cmake gcc pcre-devel gcc-c++ libgcrypt* crypt* gmp-devel bison flex xmlto lsof vim pptpd xl2tpd openvpn daemonize

##读取配置文件
dos2unix config.ini
IP_FILE=`ReadIni config.ini default IP_FILE`
RADIUSSERVER=`ReadIni config.ini default RADIUSSERVER`
RADIUSSECRET=`ReadIni config.ini default RADIUSSECRET`
RADIUSAUTH=`ReadIni config.ini default RADIUSAUTH`
RADIUSACCT=`ReadIni config.ini default RADIUSACCT`
IPSECPASS=`ReadIni config.ini default IPSECPASS`

/bin/cp $WORKPATH/tpl/limits.conf /etc/security/limits.conf
mkdir -p /etc/pptp.d/


#安装openvpn radius插件
cd ${WORKPATH}
tar -zxvf radiusplugin_v2.1a_beta1.tar.gz
cd radiusplugin_v2.1a_beta1
make clean
make -j4
/bin/cp ${WORKPATH}/radiusplugin_v2.1a_beta1/radiusplugin.so /usr/local/lib64/radiusplugin.so
chmod u+x /usr/local/lib64/radiusplugin.so

#安装strongswan
cd ${WORKPATH}
tar -zxvf strongswan-5.5.1.c7.x64.bin.tar.gz
rm -rf /usr/local/strongswan-5.5.1
mv ${WORKPATH}/strongswan-5.5.1 /usr/local
ln -s /usr/local/strongswan-5.5.1/sbin/ipsec /usr/local/bin/ipsec

cd ${WORKPATH} 
/bin/cp -R ./etc/* /etc/
/bin/cp -R ./ipsec_etc/* /usr/local/strongswan-5.5.1/etc/

##config radius
sed -i "s/RADIUSSERVER RADIUSSECRET/${RADIUSSERVER}    ${RADIUSSECRET}/g" /etc/radiusclient/servers
sed -i "s/RADIUSSERVER:1812/${RADIUSSERVER}:${RADIUSAUTH}/g" /etc/radiusclient/radiusclient.conf
sed -i "s/RADIUSSERVER:1813/${RADIUSSERVER}:${RADIUSACCT}/g" /etc/radiusclient/radiusclient.conf
#--------------------------------------------------------------#

##config ipsec
sed -i "s/IPSECPASS/${IPSECPASS}/g" /usr/local/strongswan-5.5.1/etc/ipsec.secrets
sed -i "s/GROUPNAME/${GROUPNAME}/g" /usr/local/strongswan-5.5.1/etc/ipsec.conf
sed -i "s/RADIUSSERVER/${RADIUSSERVER}/g" /usr/local/strongswan-5.5.1/etc/strongswan.conf
sed -i "s/RADIUSSECRET/${RADIUSSECRET}/g" /usr/local/strongswan-5.5.1/etc/strongswan.conf
sed -i "s/RADIUSAUTH/${RADIUSAUTH}/g" /usr/local/strongswan-5.5.1/etc/strongswan.conf
sed -i "s/RADIUSACCT/${RADIUSACCT}/g" /usr/local/strongswan-5.5.1/etc/strongswan.conf

cd $WORKPATH
#PPTP L2TP启动脚本
echo "#!/bin/bash" > /usr/local/bin/startvpn.sh
echo "killall pptpd" >> /usr/local/bin/startvpn.sh
echo "killall xl2tpd" >> /usr/local/bin/startvpn.sh
echo "echo \"start pptpd,xl2tpd ....\""  >> /usr/local/bin/startvpn.sh
#清空防火墙脚本NAT表
echo "#NAT"> $WORKPATH/fw02.sh  

NUM=1
cat $IP_FILE | while read LINE
do
	#空行跳过
	if [ ${#LINE} -lt 3 ]
	then
		continue
	fi
		
	VPNIP=`echo $LINE | cut -d \# -f 1`
	PPTPIP="172.20.${NUM}"
	L2TPIP="172.21.${NUM}"
	OPENTCPIP="172.22.${NUM}.0"
	
	echo "iptables -t nat -A POSTROUTING   -s ${PPTPIP}.0/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh 
	echo "iptables -A FORWARD -p tcp --syn -s ${PPTPIP}.0/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "iptables -t nat -A POSTROUTING   -s ${L2TPIP}.0/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh
	echo "iptables -A FORWARD -p tcp --syn -s ${L2TPIP}.0/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "iptables -t nat -A POSTROUTING   -s $OPENTCPIP/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh
	echo "iptables -A FORWARD -p tcp --syn -s $OPENTCPIP/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "#"

	echo "/usr/sbin/pptpd  -c /etc/pptp.d/pptp_${VPNIP}.conf &" >> /usr/local/bin/startvpn.sh
	echo "/usr/sbin/xl2tpd -c /etc/xl2tpd/xl2tp_${VPNIP}.conf -p /var/run/xl2tpd.${NUM}.pid &" >> /usr/local/bin/startvpn.sh
	echo "systemctl stop openvpn-server@${VPNIP}_tcp.service" >> /usr/local/bin/startvpn.sh
	echo "systemctl start openvpn-server@${VPNIP}_tcp.service" >> /usr/local/bin/startvpn.sh
	##-------------------------------------------------------
	##start radius config
	/bin/cp $WORKPATH/etc/radiusclient/radiusclient.conf /etc/radiusclient/radiusclient_${VPNIP}.conf
	sed -i "s/RADIUSSERVER:1812/${RADIUSSERVER}:${RADIUSAUTH}/g" /etc/radiusclient/radiusclient_${VPNIP}.conf
	sed -i "s/RADIUSSERVER:1813/${RADIUSSERVER}:${RADIUSACCT}/g" /etc/radiusclient/radiusclient_${VPNIP}.conf
	sed -i "s/nas_identifier VPNIP/nas_identifier ${VPNIP}/g"    /etc/radiusclient/radiusclient_${VPNIP}.conf
	
	/bin/cp $WORK/etc/ppp/options.pptpd /etc/ppp/options.pptpd.${VPNIP}
	sed -i "s/radiusclient.conf/radiusclient_${VPNIP}.conf/g" /etc/ppp/options.pptpd.${VPNIP}
	
	/bin/cp $WORK/etc/ppp/options.xl2tpd /etc/ppp/options.xl2tpd.${VPNIP}
	sed -i "s/radiusclient.conf/radiusclient_${VPNIP}.conf/g" /etc/ppp/options.xl2tpd.${VPNIP}
	##-------------------------------------------------------
	##start pptp config
	/bin/cp $WORKPATH/etc/pptpd.conf /etc/pptp.d/pptp_${VPNIP}.conf
	echo "option /etc/ppp/options.pptpd.${VPNIP}" > /etc/pptp.d/pptp_${VPNIP}.conf
	echo "localip  ${PPTPIP}.1" >> /etc/pptp.d/pptp_${VPNIP}.conf
	echo "remoteip ${PPTPIP}.2-254" >> /etc/pptp.d/pptp_${VPNIP}.conf
	echo "listen ${VPNIP}" >> /etc/pptp.d/pptp_${VPNIP}.conf
	
	##-------------------------------------------------------
	##start L2TP config
	/bin/cp $WORKPATH/etc/xl2tpd/xl2tpd.conf /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "[global]" >  /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "listen-addr = ${VPNIP}" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "ipsec saref = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "[lns default]" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "ip range = ${L2TPIP}.2-${L2TPIP}.254" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "local ip = ${L2TPIP}.1" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "refuse chap = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "refuse pap = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "require authentication = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "name = LinuxVPNserver" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "ppp debug = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "pppoptfile = /etc/ppp/options.xl2tpd.${VPNIP}" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "length bit = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "pass peer = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	
	##-------------------------------------------------------
	##start openvpn config
	/bin/cp /etc/openvpn/server/openvpn_tcp.conf  /etc/openvpn/server/${VPNIP}_tcp.conf
	/bin/cp /etc/openvpn/server/radiusplugin_tcp.cnf  /etc/openvpn/server/${VPNIP}_rd_tcp.cnf	
	sed -i "s/radiusplugin_tcp.cnf/${VPNIP}_rd_tcp.cnf/g" /etc/openvpn/server/${VPNIP}_tcp.conf
	sed -i "s/OPENVPNIP/${OPENTCPIP}/g"  /etc/openvpn/server/${VPNIP}_tcp.conf
	sed -i "s/LISTENIP/${VPNIP}/g" /etc/openvpn/server/${VPNIP}_tcp.conf	
	sed -i "s/openvpn-status.log/${VPNIP}-status-tcp.log/g" /etc/openvpn/server/${VPNIP}_tcp.conf	
	sed -i "s/openvpn.log/${VPNIP}-tcp.log/g" /etc/openvpn/server/${VPNIP}_tcp.conf	
	sed -i "s/openvpn_tcp.conf/${VPNIP}_tcp.conf/g" /etc/openvpn/server/${VPNIP}_rd_tcp.cnf
	sed -i "s/NAS-Identifier=VPNIP/NAS-Identifier=${VPNIP}/g" /etc/openvpn/server/${VPNIP}_rd_tcp.cnf
	sed -i "s/NAS-IP-Address=VPNIP/NAS-IP-Address=${VPNIP}/g" /etc/openvpn/server/${VPNIP}_rd_tcp.cnf
	sed -i "s/VPNIP_tcp.conf/${VPNIP}_tcp.conf/g" /etc/openvpn/server/${VPNIP}_rd_tcp.cnf
	sed -i "s/authport=1812/authport=${RADIUSAUTH}/g"  /etc/openvpn/server/${VPNIP}_rd_tcp.cnf
	sed -i "s/acctport=1813/acctport=${RADIUSACCT}/g"  /etc/openvpn/server/${VPNIP}_rd_tcp.cnf	
	sed -i "s/RADIUSSERVER/${RADIUSSERVER}/g" /etc/openvpn/server/${VPNIP}_rd_tcp.cnf
	sed -i "s/sharedsecret=RADIUSSECRET/sharedsecret=${RADIUSSECRET}/g" /etc/openvpn/server/${VPNIP}_rd_tcp.cnf
	#--------------------------------------------------------------#
	
	let NUM++
done


#合并防火墙脚本
cat $WORKPATH/fw01.sh  >  $WORKPATH/firewall.sh 
cat $WORKPATH/fw02.sh  >> $WORKPATH/firewall.sh 
cat $WORKPATH/fw03.sh  >> $WORKPATH/firewall.sh 
dos2unix $WORKPATH/firewall.sh
/bin/cp $WORKPATH/firewall.sh  /usr/local/bin/firewall.sh
chmod u+x /usr/local/bin/firewall.sh

#--------------------------------------------------------------#
systemctl disable pptpd.service
systemctl stop pptpd.service

systemctl disable xl2tpd.service
systemctl stop xl2tpd.service

systemctl enable iptables
systemctl start iptables

chmod 755 /usr/local/bin/startvpn.sh
chmod 755 /etc/rc.d/rc.local
RC_NUM=`cat /etc/rc.local | grep startvpn.sh | wc -l`
if [ $RC_NUM -eq 0 ]
then
	echo "/usr/local/strongswan-5.5.1/sbin/ipsec start" >> /etc/rc.d/rc.local
	echo "/usr/local/bin/firewall.sh" >> /etc/rc.d/rc.local
	echo "/usr/local/bin/startvpn.sh" >> /etc/rc.local
fi

/usr/local/strongswan-5.5.1/sbin/ipsec restart
/usr/local/bin/firewall.sh
/usr/local/bin/startvpn.sh

