#!/bin/bash
####################################################
# date  :2024-08-05                                #
# setup openvpn pptpd l2tpd to centos7             #
####################################################
#PPTP:172.20.1.2-172.20.255.254
#L2TP:172.21.1.2-172.21.255.254
#OVPN:172.22.1.2-172.22.255.254
#SSTP:172.23.1.2-172.23.255.254

if [ $(id -u) != "0" ]; then
    printf "Error: You must be root to run this tool!\n"
    exit 1
fi

#工作目录
WORKPATH=`pwd`

ReadIni() {
    file=$1;section=$2;item=$3;
    val=$(awk -F '=' '/\['${section}'\]/{a=1} (a==1 && "'${item}'"==$1){a=0;print $2}' ${file}) 
    echo ${val}
}

##open IP forward
echo 1 > /proc/sys/net/ipv4/ip_forward
if [ `cat /usr/lib/sysctl.d/50-default.conf | grep ip_forward | wc -l` -eq 0 ]
then
	echo "net.ipv4.ip_forward = 1" >> /usr/lib/sysctl.d/50-default.conf
	echo "net.netfilter.nf_conntrack_tcp_timeout_established = 1200" >> /usr/lib/sysctl.d/50-default.conf
	echo "net.netfilter.nf_conntrack_max = 1255350" >> /usr/lib/sysctl.d/50-default.conf
	echo "net.ipv6.conf.all.disable_ipv6 = 1" >> /usr/lib/sysctl.d/50-default.conf
	echo "net.ipv6.conf.default.disable_ipv6 = 1" >> /usr/lib/sysctl.d/50-default.conf
fi
/sbin/sysctl -p /usr/lib/sysctl.d/50-default.conf

#禁用firewalld服务
systemctl stop firewalld
systemctl mask firewalld

#yum clean all
yum -y install epel-release
yum -y install psmisc dos2unix wget unzip ppp openssl-devel pcre-devel libgcrypt-devel iptables-services make cmake gcc gcc-c++ pcre-devel vim xl2tpd openvpn strongswan
##读取配置文件
dos2unix config.ini
IP_FILE=`ReadIni config.ini default IP_FILE`
RADIUSSERVER=`ReadIni config.ini default RADIUSSERVER`
RADIUSSECRET=`ReadIni config.ini default RADIUSSECRET`
RADIUSAUTH=`ReadIni config.ini default RADIUSAUTH`
RADIUSACCT=`ReadIni config.ini default RADIUSACCT`
IPSECPASS=`ReadIni config.ini default IPSECPASS`

#安装accel-ppp
cd ${WORKPATH}
unzip -o accel-ppp-1.13.0.zip
mkdir -p accel-ppp-build
cd accel-ppp-build
cmake -DCMAKE_INSTALL_PREFIX=/usr/local/accel-ppp -DCMAKE_BUILD_TYPE=Release ../accel-ppp-1.13.0/
make -j4
make install

#安装openvpn radius插件
cd ${WORKPATH}
tar -zxvf radiusplugin_v2.1a_beta1.tar.gz
cd radiusplugin_v2.1a_beta1
#make clean
make -j4
/bin/cp ${WORKPATH}/radiusplugin_v2.1a_beta1/radiusplugin.so /usr/local/lib64/radiusplugin.so
chmod u+x /usr/local/lib64/radiusplugin.so

#start init config
cd ${WORKPATH} 
/bin/cp $WORKPATH/mykillall.sh /usr/local/bin/mykillall.sh
chmod 755 /usr/local/bin/mykillall.sh
/bin/cp $WORKPATH/limits.conf /etc/security/limits.conf
/bin/cp -R ./etc/* /etc/


##config radius
cd ${WORKPATH} 
sed -i "s/RADIUSSERVER RADIUSSECRET/${RADIUSSERVER}    ${RADIUSSECRET}/g" /etc/radiusclient/servers
sed -i "s/RADIUSSERVER:1812/${RADIUSSERVER}:${RADIUSAUTH}/g" /etc/radiusclient/radiusclient.conf
sed -i "s/RADIUSSERVER:1813/${RADIUSSERVER}:${RADIUSACCT}/g" /etc/radiusclient/radiusclient.conf
#--------------------------------------------------------------#

#config strongswan
sed -i "s/IPSECPASS/${IPSECPASS}/g" /etc/strongswan/ipsec.secrets

cd $WORKPATH
#PPTP L2TP启动脚本
echo "#!/bin/bash" > /usr/local/bin/startvpn.sh
echo "killall xl2tpd" >> /usr/local/bin/startvpn.sh
echo "echo \"start pptpd,xl2tpd ....\""  >> /usr/local/bin/startvpn.sh
echo "killall accel-pppd">> /usr/local/bin/startvpn.sh
echo "/usr/local/bin/mykillall.sh accel-pppd">> /usr/local/bin/startvpn.sh
echo "killall xl2tpd">> /usr/local/bin/startvpn.sh
echo "/usr/local/bin/mykillall.sh xl2tpd">> /usr/local/bin/startvpn.sh	
echo "/usr/sbin/strongswan restart">> /usr/local/bin/startvpn.sh
echo "##">> /usr/local/bin/startvpn.sh

#清空防火墙脚本NAT表
echo "#NAT"> $WORKPATH/fw02.sh  

NUM=1
cat $IP_FILE | while read LINE
do
	#空行跳过
	if [ ${#LINE} -lt 3 ]
	then
		continue
	fi
		
	VPNIP=`echo $LINE | cut -d \# -f 1`
	#IP池的前面3段,例如192.18.3
	PPTP_P3="172.20.${NUM}"
	L2TP_P3="172.21.${NUM}"
	OVPN_P3="172.22.${NUM}"
	SSTP_p3="172.23.${NUM}"
	let ACCEL_DAE_PORT=NUM+4000
	let OVPN_MAN_PORT=NUM+3000
	
	echo "iptables -t nat -A POSTROUTING   -s ${PPTP_P3}.0/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh 
	echo "iptables -A FORWARD -p tcp --syn -s ${PPTP_P3}.0/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "iptables -t nat -A POSTROUTING   -s ${L2TP_P3}.0/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh
	echo "iptables -A FORWARD -p tcp --syn -s ${L2TP_P3}.0/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "iptables -t nat -A POSTROUTING   -s ${OVPN_P3}.0/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh
	echo "iptables -A FORWARD -p tcp --syn -s ${OVPN_P3}.0/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "iptables -t nat -A POSTROUTING   -s ${SSTP_p3}.0/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh
	echo "iptables -A FORWARD -p tcp --syn -s ${SSTP_p3}.0/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "#" >> $WORKPATH/fw02.sh 


	echo "/usr/local/accel-ppp/sbin/accel-pppd -c /etc/accel-ppp/accel-ppp_${VPNIP}.conf -d" >> /usr/local/bin/startvpn.sh
	echo "/usr/sbin/xl2tpd -c /etc/xl2tpd/xl2tp_${VPNIP}.conf -p /var/run/xl2tpd.${NUM}.pid &" >> /usr/local/bin/startvpn.sh
	echo "systemctl stop openvpn-server@${VPNIP}" >> /usr/local/bin/startvpn.sh
	echo "systemctl start openvpn-server@${VPNIP}" >> /usr/local/bin/startvpn.sh
	echo "##" >> /usr/local/bin/startvpn.sh
	##-------------------------------------------------------
	##start radius config
	/bin/cp $WORKPATH/etc/radiusclient/radiusclient.conf /etc/radiusclient/radiusclient_${VPNIP}.conf
	sed -i "s/RADIUSSERVER:1812/${RADIUSSERVER}:${RADIUSAUTH}/g" /etc/radiusclient/radiusclient_${VPNIP}.conf
	sed -i "s/RADIUSSERVER:1813/${RADIUSSERVER}:${RADIUSACCT}/g" /etc/radiusclient/radiusclient_${VPNIP}.conf
	sed -i "s/nas_identifier VPNIP/nas_identifier ${VPNIP}/g"    /etc/radiusclient/radiusclient_${VPNIP}.conf
	
	/bin/cp $WORK/etc/ppp/options.pptpd /etc/ppp/options.pptpd.${VPNIP}
	sed -i "s/radiusclient.conf/radiusclient_${VPNIP}.conf/g" /etc/ppp/options.pptpd.${VPNIP}
	
	/bin/cp $WORK/etc/ppp/options.xl2tpd /etc/ppp/options.xl2tpd.${VPNIP}
	sed -i "s/radiusclient.conf/radiusclient_${VPNIP}.conf/g" /etc/ppp/options.xl2tpd.${VPNIP}
	##-------------------------------------------------------
	##start L2TP config
	/bin/cp $WORKPATH/etc/xl2tpd/xl2tpd.conf /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "[global]" >  /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "listen-addr = ${VPNIP}" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "ipsec saref = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "[lns default]" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "ip range = ${L2TP_P3}.2-${L2TP_P3}.254" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "local ip = ${L2TP_P3}.1" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "refuse chap = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "refuse pap = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "require authentication = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "name = L2TPServer" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "ppp debug = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "pppoptfile = /etc/ppp/options.xl2tpd.${VPNIP}" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "length bit = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "pass peer = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf

	##start pptp and sstp config
	/bin/cp $WORKPATH/etc/accel-ppp/accel-ppp.conf /etc/accel-ppp/accel-ppp_${VPNIP}.conf
	sed -i "s/VPNIP/${VPNIP}/g" /etc/accel-ppp/accel-ppp_${VPNIP}.conf
	sed -i "s/PPTP_P3/${PPTP_P3}/g" /etc/accel-ppp/accel-ppp_${VPNIP}.conf
	sed -i "s/SSTP_p3/${SSTP_p3}/g" /etc/accel-ppp/accel-ppp_${VPNIP}.conf
	sed -i "s/ACCEL_DAE_PORT/${ACCEL_DAE_PORT}/g" /etc/accel-ppp/accel-ppp_${VPNIP}.conf
	sed -i "s/RADIUSSERVER/${RADIUSSERVER}/g" /etc/accel-ppp/accel-ppp_${VPNIP}.conf
	sed -i "s/RADIUSSECRET/${RADIUSSECRET}/g" /etc/accel-ppp/accel-ppp_${VPNIP}.conf

	##-------------------------------------------------------
	##start openvpn config
	/bin/cp /etc/openvpn/server/tpl.conf  /etc/openvpn/server/${VPNIP}.conf
	/bin/cp /etc/openvpn/server/tpl.radius  /etc/openvpn/server/${VPNIP}.radius	
	sed -i "s/OVPN_MAN_PORT/${OVPN_MAN_PORT}/g" /etc/openvpn/server/${VPNIP}.conf
	sed -i "s/VPNIP.radius/${VPNIP}.radius/g" /etc/openvpn/server/${VPNIP}.conf
	sed -i "s/OPENVPNIP/${OVPN_P3}.0/g"  /etc/openvpn/server/${VPNIP}.conf
	sed -i "s/LISTENIP/${VPNIP}/g" /etc/openvpn/server/${VPNIP}.conf	
	sed -i "s/openvpn-status.log/${VPNIP}-status.log/g" /etc/openvpn/server/${VPNIP}.conf	
	sed -i "s/openvpn.log/${VPNIP}-run.log/g" /etc/openvpn/server/${VPNIP}.conf	
	sed -i "s/NAS-Identifier=VPNIP/NAS-Identifier=${VPNIP}/g" /etc/openvpn/server/${VPNIP}.radius
	sed -i "s/NAS-IP-Address=VPNIP/NAS-IP-Address=${VPNIP}/g" /etc/openvpn/server/${VPNIP}.radius
	sed -i "s/VPNIP.conf/${VPNIP}.conf/g" /etc/openvpn/server/${VPNIP}.radius
	sed -i "s/authport=1812/authport=${RADIUSAUTH}/g"  /etc/openvpn/server/${VPNIP}.radius
	sed -i "s/acctport=1813/acctport=${RADIUSACCT}/g"  /etc/openvpn/server/${VPNIP}.radius	
	sed -i "s/RADIUSSERVER/${RADIUSSERVER}/g" /etc/openvpn/server/${VPNIP}.radius
	sed -i "s/sharedsecret=RADIUSSECRET/sharedsecret=${RADIUSSECRET}/g" /etc/openvpn/server/${VPNIP}.radius
	#--------------------------------------------------------------#
	
	let NUM++
done


#合并防火墙脚本
cat $WORKPATH/fw01.sh  >  $WORKPATH/firewall.sh 
cat $WORKPATH/fw02.sh  >> $WORKPATH/firewall.sh 
cat $WORKPATH/fw03.sh  >> $WORKPATH/firewall.sh 
dos2unix $WORKPATH/firewall.sh
/bin/cp $WORKPATH/firewall.sh  /usr/local/bin/firewall.sh
chmod u+x /usr/local/bin/firewall.sh

#--------------------------------------------------------------#
systemctl disable xl2tpd.service
systemctl stop xl2tpd.service

systemctl enable iptables
systemctl start iptables

systemctl enable rc-local
chmod 755 /usr/local/bin/startvpn.sh
chmod 755 /etc/rc.d/rc.local
RC_NUM=`cat /etc/rc.local | grep startvpn.sh | wc -l`
if [ $RC_NUM -eq 0 ]
then
	echo "/usr/local/bin/firewall.sh" >> /etc/rc.d/rc.local
	echo "/usr/local/bin/startvpn.sh" >> /etc/rc.local
fi

/usr/local/bin/firewall.sh
/usr/local/bin/startvpn.sh
