#!/bin/bash

# 检查是否提供了进程名称参数
if [ -z "$1" ]; then
  echo "usage: $0 <processname>"
  exit 1
fi

# 获取所有匹配的进程 ID
PIDS=$(pgrep "$1")

# 检查是否找到了匹配的进程
if [ -z "$PIDS" ]; then
  echo "not found '$1' "
  exit 1
fi

# 终止所有找到的进程
for PID in $PIDS; do
  kill -9 "$PID"
  echo "killed PID: $PID"
done
