#!/bin/sh
#
## Flush rules & reset counters
iptables -F
iptables -Z
iptables -X
iptables -t nat -F
iptables -t nat -Z
iptables -t nat -X
#
## Set policies
iptables -P INPUT DROP
iptables -P FORWARD ACCEPT
iptables -P OUTPUT DROP
#
## Pass all locally-originating packets
iptables -A INPUT -i lo -j ACCEPT
iptables -A OUTPUT -o lo -j ACCEPT
#
## Allow transparence proxy
#iptables -t nat -A PREROUTING -p tcp --dport 80 -j REDIRECT --to-port 3128
#
## Accept ICMP ping echo requests
## (this allows other people to ping your machine, among other things),
iptables -A INPUT -p icmp --icmp-type echo-request -j ACCEPT
#iptables -t nat -A POSTROUTING -s 192.168.130.0/24  -j MASQUERADE

iptables -A FORWARD  -d 58.251.100.0/24 -j REJECT
iptables -A FORWARD  -d 163.177.81.0/24 -j REJECT
iptables -A FORWARD  -d 58.251.111.0/24 -j REJECT
iptables -A FORWARD  -d 58.251.117.0/24 -j REJECT
iptables -A FORWARD  -d 109.244.169.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.232.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.233.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.202.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.209.0/24 -j REJECT
iptables -A FORWARD  -d 113.105.166.0/24 -j REJECT
iptables -A FORWARD  -d 14.18.175.0/24 -j REJECT
iptables -A FORWARD  -d 123.150.208.0/24 -j REJECT
iptables -A FORWARD  -d 59.36.121.0/24 -j REJECT
iptables -A FORWARD  -d 61.151.165.0/24 -j REJECT
iptables -A FORWARD  -d 123.150.208.0/24 -j REJECT
iptables -A FORWARD  -d 101.91.19.0/24 -j REJECT
iptables -A FORWARD  -d 59.36.89.0/24 -j REJECT
iptables -A FORWARD  -d 183.3.234.0/24 -j REJECT
iptables -A FORWARD  -d 14.215.158.0/24 -j REJECT
iptables -A FORWARD  -d 123.151.190.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.237.0/24 -j REJECT
iptables -A FORWARD  -d 157.255.174.0/24 -j REJECT
iptables -A FORWARD  -d 58.251.80.0/24 -j REJECT
iptables -A FORWARD  -d 163.177.81.0/24 -j REJECT
iptables -A FORWARD  -d 183.3.224.0/24 -j REJECT
iptables -A FORWARD  -d 101.89.15.0/24 -j REJECT
iptables -A FORWARD  -d 111.62.249.0/24 -j REJECT
iptables -A FORWARD  -d 223.111.24.0/24 -j REJECT
iptables -A FORWARD  -d 111.30.144.0/24 -j REJECT
iptables -A FORWARD  -d 121.51.158.0/24 -j REJECT
iptables -A FORWARD  -d 111.30.171.0/24 -j REJECT
iptables -A FORWARD  -d 104.31.65.0/24 -j REJECT
iptables -A FORWARD  -d 112.60.14.0/24 -j REJECT
iptables -A FORWARD  -d 101.91.19.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.13.0/24 -j REJECT
iptables -A FORWARD  -d 14.22.3.0/24 -j REJECT
iptables -A FORWARD  -d 183.3.224.0/24 -j REJECT
iptables -A FORWARD  -d 183.60.155.0/24 -j REJECT
iptables -A FORWARD  -d 59.36.119.0/24 -j REJECT
iptables -A FORWARD  -d 14.116.136.0/24 -j REJECT
iptables -A FORWARD  -d 180.97.117.0/24 -j REJECT
iptables -A FORWARD  -d 124.225.105.0/24 -j REJECT
iptables -A FORWARD  -d 14.215.85.0/24 -j REJECT
iptables -A FORWARD  -d 183.2.192.0/24 -j REJECT
iptables -A FORWARD  -d 42.202.154.0/24 -j REJECT
iptables -A FORWARD  -d 114.221.144.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.208.0/24 -j REJECT
iptables -A FORWARD  -d 42.202.154.0/24 -j REJECT
iptables -A FORWARD  -d 14.22.33.0/24 -j REJECT
iptables -A FORWARD  -d 180.97.117.0/24 -j REJECT
iptables -A FORWARD  -d 119.147.83.0/24 -j REJECT
iptables -A FORWARD  -d 101.91.63.0/24 -j REJECT
iptables -A FORWARD  -d 58.60.9.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.12.0/24 -j REJECT
iptables -A FORWARD  -d 14.215.85.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.156.0/24 -j REJECT
iptables -A FORWARD  -d 59.63.237.0/24 -j REJECT
iptables -A FORWARD  -d 14.18.180.0/24 -j REJECT
iptables -A FORWARD  -d 14.18.160.0/24 -j REJECT
iptables -A FORWARD  -d 14.17.27.0/24 -j REJECT
iptables -A FORWARD  -d 183.3.225.0/24 -j REJECT
iptables -A FORWARD  -d 61.151.207.0/24 -j REJECT
iptables -A FORWARD  -d 183.3.225.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.237.0/24 -j REJECT
iptables -A FORWARD  -d 183.3.226.0/24 -j REJECT
iptables -A FORWARD  -d 113.105.154.0/24 -j REJECT
iptables -A FORWARD  -d 124.225.105.0/24 -j REJECT
iptables -A FORWARD  -d 183.3.235.0/24 -j REJECT
iptables -A FORWARD  -d 221.228.67.0/24 -j REJECT
iptables -A FORWARD  -d 123.161.61.0/24 -j REJECT
iptables -A FORWARD  -d 221.228.67.0/24 -j REJECT
iptables -A FORWARD  -d 109.244.128.0/24 -j REJECT
iptables -A FORWARD  -d 183.3.226.0/24 -j REJECT
iptables -A FORWARD  -d 61.142.166.0/24 -j REJECT
iptables -A FORWARD  -d 113.96.83.0/24 -j REJECT
iptables -A FORWARD  -d 124.232.162.0/24 -j REJECT
iptables -A FORWARD  -d 125.94.49.0/24 -j REJECT
iptables -A FORWARD  -d 219.135.59.0/24 -j REJECT
iptables -A FORWARD  -d 59.37.97.0/24 -j REJECT
iptables -A FORWARD  -d 183.36.108.0/24 -j REJECT
iptables -A FORWARD  -d 183.3.233.0/24 -j REJECT
iptables -A FORWARD  -d 101.89.38.0/24 -j REJECT
iptables -A FORWARD  -d 59.36.120.0/24 -j REJECT
iptables -A FORWARD  -d 58.60.15.0/24 -j REJECT
iptables -A FORWARD  -d 58.61.32.0/24 -j REJECT
iptables -A FORWARD  -d 58.61.33.0/24 -j REJECT
iptables -A FORWARD  -d 58.61.34.0/24 -j REJECT
iptables -A FORWARD  -d 58.61.165.0/24 -j REJECT
iptables -A FORWARD  -d 58.251.58.0/24 -j REJECT
iptables -A FORWARD  -d 58.251.60.0/24 -j REJECT
iptables -A FORWARD  -d 58.251.61.0/24 -j REJECT
iptables -A FORWARD  -d 58.251.63.0/24 -j REJECT
iptables -A FORWARD  -d 119.147.9.0/24 -j REJECT
iptables -A FORWARD  -d 119.147.11.0/24 -j REJECT
iptables -A FORWARD  -d 119.147.12.0/24 -j REJECT
iptables -A FORWARD  -d 119.147.13.0/24 -j REJECT
iptables -A FORWARD  -d 182.254.11.0/24 -j REJECT
iptables -A FORWARD  -d 140.207.54.0/24 -j REJECT
iptables -A FORWARD  -d 101.226.103.0/24 -j REJECT
iptables -A FORWARD  -d 101.226.62.0/24 -j REJECT
iptables -A FORWARD  -d 14.22.33.0/24 -j REJECT
iptables -A FORWARD  -d 49.4.19.0/24 -j REJECT
iptables -A FORWARD  -d 113.105.166.0/24 -j REJECT
iptables -A FORWARD  -d 123.151.176.0/24 -j REJECT
iptables -A FORWARD  -d 59.36.121.0/24 -j REJECT
iptables -A FORWARD  -d 121.14.76.0/24 -j REJECT
iptables -A FORWARD -p tcp -m string --string "*.qq.com" --algo bm -j DROP
iptables -A FORWARD -p udp -m string --string "*.qq.com" --algo kmp -j DROP