#!/bin/bash
####################################################
# author:Donghai qq258320458					   #
# date  :2012-11-24                                #
# setup openvpn pptpd l2tpd to centos5             #
####################################################
#PPTP:172.20.10.10-172.20.250.250
#L2TP:172.21.10.10-172.21.250.250
#OPENVPN-TCP:172.22.10.10-172.22.250.250
#OPENVPN-UDP:172.23.10.10-172.23.250.250
if [ $(id -u) != "0" ]; then
    printf "Error: You must be root to run this tool!\n"
    exit 1
fi
#禁止SELINUX
setenforce 0
service openvpn stop
#主IP
MAINIP=`ifconfig  | grep 'inet addr:'| grep -v '127.0.0.1' | cut -d: -f2 | awk 'NR==1 { print $1}'`
#脚本目录
WORKPATH=`pwd`
#IP总数
IPCOUNT=`ifconfig  | grep 'inet addr:'| grep -v '127.0.0.1' | cut -d: -f2 | wc -l`
#IPSEC 预共享密钥
L2TPPSK="88888888"
#radius服务器
RADIUSSERVER="ra.10028.it"
#radius密钥
RADIUSSECRET="vpn2000"
#radius验证端口
RADIUSAUTH="1812"
#radius记账端口
RADIUSACCT="1813"
#开启IP转发
mkdir -p /etc/pptp.d
mkdir -p /etc/dante/
sed -i 's/net.ipv4.ip_forward = 0/net.ipv4.ip_forward = 1/g' /etc/sysctl.conf 
/sbin/sysctl -p
/bin/cp forward.sh  /usr/local/bin/
chmod u+x /usr/local/bin/forward.sh
/bin/cp -R $WORKPATH/etc/* /etc/
mknod /dev/ppp c 108 0 
##start radius config
sed -i "s/RADIUSSERVER RADIUSSECRET/${RADIUSSERVER}    ${RADIUSSECRET}/g" /etc/radiusclient/servers
sed -i "s/RADIUSSERVER:1812/${RADIUSSERVER}:${RADIUSAUTH}/g" /etc/radiusclient/radiusclient.conf
sed -i "s/RADIUSSERVER:1813/${RADIUSSERVER}:${RADIUSACCT}/g" /etc/radiusclient/radiusclient.conf
sed -i "s/nas_identifier VPNIP/nas_identifier ${MAINIP}/g" 	 /etc/radiusclient/radiusclient.conf
#--------------------------------------------------------------#
##start pptp config

#--------------------------------------------------------------#
##start xl2tpd config
sed -i "s/=VPNIP/=${MAINIP}/g" /etc/ipsec.conf
sed -i "s/VPNIP/${MAINIP}/g" /etc/ipsec.secrets
sed -i "s/L2TPPSK/${L2TPPSK}/g" /etc/ipsec.secrets
cp ./bin/l2tp-control /usr/local/bin/
chmod u+x /usr/local/bin/l2tp-control
mkdir /var/run/xl2tpd/
ln -s /usr/local/bin/l2tp-control /var/run/xl2tpd/l2tp-control
	
for each in /proc/sys/net/ipv4/conf/*
do
	echo 0 > $each/accept_redirects
	echo 0 > $each/send_redirects
done
#--------------------------------------------------------------#
echo "1" > /proc/sys/net/core/xfrm_larval_drop
rpm -ivh epel-release-6-5.noarch.rpm ius-release-1.0-9.ius.el6.noarch.rpm
rm -f /etc/yum.repos.d/epel.repo
/bin/cp $WORKPATH/epel.repo /etc/yum.repos.d/epel.repo
yum -y install dos2unix patch dkms kernel_ppp_mppe libpcap-devel ppp pkcs11-helper-devel openssl-devel xl2tpd openswan freeradius-utils iptables make gcc-c++ libgcrypt* crypt* freeradius
yum -y install  make gcc gmp-devel xmlto bison flex xmlto lsof vim-enhanced perl-Net-SSLeay perl-Crypt-SSLeay  perl-Encode-Detect gcc make bison flex rpm-build  openldap-devel pam-devel openssl-devel libgssapi-devel libgssapi-devel
rpm -ivh pptpd-1.3.4-2.el6.x86_64.rpm
rpm -ivh xl2tpd-1.3.1-7.el6.x86_64.rpm
rpm -ev openvpn
tar -zxvf lzo-2.06.tar.gz
cd lzo-2.06
./configure
make
make install
cd $WORKPATH
tar -zxvf openvpn-2.2.2.tar.gz
cd openvpn-2.2.2
cp ../openvpn-2.2.2-obfs.patch ./
patch < openvpn-2.2.2-obfs.patch
./configure
make
make install
mkdir -p /etc/openvpn
cd sample-scripts/
cp openvpn.init /etc/init.d/openvpn
cd $WORKPATH
tar -zxvf radiusplugin_v2.1a_beta1.tar.gz
cd radiusplugin_v2.1a_beta1
make
/bin/cp radiusplugin.so /etc/openvpn/radiusplugin.so
chmod u+x /etc/openvpn/radiusplugin.so
cd $WORKPATH
tar -zxvf rp-l2tp-0.4.tar.gz
cd rp-l2tp-0.4
./configure
make
/bin/cp handlers/l2tp-control /usr/local/bin/
cd $WORKPATH
tar -zxvf dante-1.4.2.tar.gz
cd dante-1.4.2
./configure --prefix=/usr/local/dante-1.4.2
make 
make install
ln -s /usr/local/dante-1.4.2/sbin/sockd  /usr/local/bin/danted
cd $WORKPATH
#PPTP L2TP启动脚本
echo "#!/bin/bash" > /usr/local/bin/startvpn.sh
echo "killall pptpd" >> /usr/local/bin/startvpn.sh
echo "killall xl2tpd" >> /usr/local/bin/startvpn.sh
echo "echo \"start pptpd,xl2tpd ....\""  >> /usr/local/bin/startvpn.sh

#dante启动脚本
echo "#!/bin/bash" > /usr/local/bin/startdanted.sh
echo "killall danted" >> /usr/local/bin/startdanted.sh
echo "echo \"start danted ....\""  >> /usr/local/bin/startdanted.sh
#清空防火墙脚本NAT表
echo "#NAT"> $WORKPATH/fw02.sh  

SOCKS5_START_PORT=18002; #socks5开始端口
for((i=1;i<=$IPCOUNT;i++))
do
	#循环获取IP
	VPNIP=`ifconfig  | grep 'inet addr:'| grep -v '127.0.0.1' | cut -d: -f2 |sed -n "${i}p"| awk 'NR==1 { print $1}'`
	IPEND=0
	let "IPEND = $IPEND + 10 + $i -1"
	PPTPIP="172.20."${IPEND}
	L2TPIP="172.21."${IPEND}
	OPENTCPIP="172.22."${IPEND}".0"
	OPENUDPIP="172.23."${IPEND}".0"
	echo "iptables -t nat -A POSTROUTING   -s ${PPTPIP}.0/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh 
	echo "iptables -A FORWARD -p tcp --syn -s ${PPTPIP}.0/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "iptables -t nat -A POSTROUTING   -s ${L2TPIP}.0/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh
	echo "iptables -A FORWARD -p tcp --syn -s ${L2TPIP}.0/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "iptables -t nat -A POSTROUTING   -s $OPENTCPIP/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh
	echo "iptables -A FORWARD -p tcp --syn -s $OPENTCPIP/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo "iptables -t nat -A POSTROUTING   -s $OPENUDPIP/24 -j SNAT --to $VPNIP" >> $WORKPATH/fw02.sh	
	echo "iptables -A FORWARD -p tcp --syn -s $OPENUDPIP/24 -j TCPMSS --set-mss 1356" >> $WORKPATH/fw02.sh 
	echo " /usr/sbin/pptpd -c   /etc/pptp.d/pptp_${VPNIP}.conf & " >> /usr/local/bin/startvpn.sh
    echo " /usr/sbin/xl2tpd -c /etc/xl2tpd/xl2tp_${VPNIP}.conf -p /var/run/xl2tpd$i.pid & " >> /usr/local/bin/startvpn.sh
	##-------------------------------------------------------
	##start radius config
	/bin/cp $WORKPATH/etc/radiusclient/radiusclient.conf /etc/radiusclient/radiusclient_${VPNIP}.conf
	sed -i "s/RADIUSSERVER:1812/${RADIUSSERVER}:${RADIUSAUTH}/g" /etc/radiusclient/radiusclient_${VPNIP}.conf
	sed -i "s/RADIUSSERVER:1813/${RADIUSSERVER}:${RADIUSACCT}/g" /etc/radiusclient/radiusclient_${VPNIP}.conf
	sed -i "s/nas_identifier VPNIP/nas_identifier ${VPNIP}/g"    /etc/radiusclient/radiusclient_${VPNIP}.conf
	
	/bin/cp $WORK/etc/ppp/options.pptpd /etc/ppp/options.pptpd.${VPNIP}
	sed -i "s/radiusclient.conf/radiusclient_${VPNIP}.conf/g" /etc/ppp/options.pptpd.${VPNIP}
	
	/bin/cp $WORK/etc/ppp/options.xl2tpd /etc/ppp/options.xl2tpd.${VPNIP}
	sed -i "s/radiusclient.conf/radiusclient_${VPNIP}.conf/g" /etc/ppp/options.xl2tpd.${VPNIP}
	##-------------------------------------------------------
	##start pptp config
	/bin/cp $WORKPATH/etc/pptpd.conf /etc/pptp.d/pptp_${VPNIP}.conf
	echo "option /etc/ppp/options.pptpd.${VPNIP}" > /etc/pptp.d/pptp_${VPNIP}.conf
	echo "localip  ${PPTPIP}.1" >> /etc/pptp.d/pptp_${VPNIP}.conf
	echo "remoteip ${PPTPIP}.10-250" >> /etc/pptp.d/pptp_${VPNIP}.conf
	echo "listen ${VPNIP}" >> /etc/pptp.d/pptp_${VPNIP}.conf
	
	##-------------------------------------------------------
	##start L2TP config
	/bin/cp $WORKPATH/etc/xl2tpd/xl2tpd.conf /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "[global]" >  /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "listen-addr = ${VPNIP}" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "ipsec saref = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "[lns default]" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "ip range = ${L2TPIP}.10-${L2TPIP}.254" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "local ip = ${L2TPIP}.1" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "refuse chap = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "refuse pap = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "require authentication = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "name = LinuxVPNserver" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "ppp debug = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "pppoptfile = /etc/ppp/options.xl2tpd.${VPNIP}" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	echo "length bit = yes" >> /etc/xl2tpd/xl2tp_${VPNIP}.conf
	
	##-------------------------------------------------------
	##start openvpn config
	echo $i >>/tmp/1.txt
	/bin/cp /etc/openvpn/openvpn_tcp.conf  /etc/openvpn/${VPNIP}_tcp.conf
	/bin/cp /etc/openvpn/openvpn_udp.conf  /etc/openvpn/${VPNIP}_udp.conf 	
	/bin/cp /etc/openvpn/radiusplugin_tcp.cnf  /etc/openvpn/${VPNIP}_rd_tcp.cnf
	/bin/cp /etc/openvpn/radiusplugin_udp.cnf  /etc/openvpn/${VPNIP}_rd_udp.cnf
	
	sed -i "s/radiusplugin_tcp.cnf/${VPNIP}_rd_tcp.cnf/g" /etc/openvpn/${VPNIP}_tcp.conf
	sed -i "s/radiusplugin_udp.cnf/${VPNIP}_rd_udp.cnf/g" /etc/openvpn/${VPNIP}_udp.conf
	sed -i "s/OPENVPNIP/${OPENTCPIP}/g"  /etc/openvpn/${VPNIP}_tcp.conf
	sed -i "s/OPENVPNIP/${OPENUDPIP}/g"  /etc/openvpn/${VPNIP}_udp.conf
	sed -i "s/LISTENIP/${VPNIP}/g" /etc/openvpn/${VPNIP}_tcp.conf
	sed -i "s/LISTENIP/${VPNIP}/g" /etc/openvpn/${VPNIP}_udp.conf
	
	sed -i "s/openvpn-status.log/openvpn-status-tcp-${VPNIP}.log/g" /etc/openvpn/${VPNIP}_tcp.conf
	sed -i "s/openvpn-status.log/openvpn-status-udp-${VPNIP}.log/g" /etc/openvpn/${VPNIP}_udp.conf
	
	sed -i "s/openvpn.log/openvpn-tcp-${VPNIP}.log/g" /etc/openvpn/${VPNIP}_tcp.conf
	sed -i "s/openvpn.log/openvpn-udp-${VPNIP}.log/g" /etc/openvpn/${VPNIP}_udp.conf
	
	sed -i "s/openvpn_tcp.conf/${VPNIP}_tcp.conf/g" /etc/openvpn/${VPNIP}_rd_tcp.cnf
	sed -i "s/openvpn_udp.conf/${VPNIP}_udp.conf/g" /etc/openvpn/${VPNIP}_rd_udp.cnf	
	sed -i "s/NAS-Identifier=VPNIP/NAS-Identifier=${VPNIP}/g" /etc/openvpn/${VPNIP}_rd_tcp.cnf
	sed -i "s/NAS-Identifier=VPNIP/NAS-Identifier=${VPNIP}/g" /etc/openvpn/${VPNIP}_rd_udp.cnf
	sed -i "s/NAS-IP-Address=VPNIP/NAS-IP-Address=${VPNIP}/g" /etc/openvpn/${VPNIP}_rd_tcp.cnf
	sed -i "s/NAS-IP-Address=VPNIP/NAS-IP-Address=${VPNIP}/g" /etc/openvpn/${VPNIP}_rd_udp.cnf
	sed -i "s/authport=1812/authport=${RADIUSAUTH}/g"  /etc/openvpn/${VPNIP}_rd_tcp.cnf
	sed -i "s/acctport=1813/acctport=${RADIUSACCT}/g"  /etc/openvpn/${VPNIP}_rd_tcp.cnf	
	sed -i "s/authport=1812/authport=${RADIUSAUTH}/g" /etc/openvpn/${VPNIP}_rd_udp.cnf
	sed -i "s/acctport=1813/acctport=${RADIUSACCT}/g" /etc/openvpn/${VPNIP}_rd_udp.cnf	
	sed -i "s/RADIUSSERVER/${RADIUSSERVER}/g" /etc/openvpn/${VPNIP}_rd_tcp.cnf
	sed -i "s/RADIUSSERVER/${RADIUSSERVER}/g" /etc/openvpn/${VPNIP}_rd_udp.cnf	
	sed -i "s/sharedsecret=RADIUSSECRET/sharedsecret=${RADIUSSECRET}/g" /etc/openvpn/${VPNIP}_rd_tcp.cnf
	sed -i "s/sharedsecret=RADIUSSECRET/sharedsecret=${RADIUSSECRET}/g" /etc/openvpn/${VPNIP}_rd_udp.cnf
	#--------------------------------------------------------------#
	##start dante config
	echo "/usr/local/bin/danted -D -f /etc/dante/${i}.conf" >> /usr/local/bin/startdanted.sh
	let "SOCKS5_PORT = $SOCKS5_START_PORT + $i -1"
	cat >>/etc/dante/${i}.conf<<EOF
internal: 0.0.0.0  port = $SOCKS5_PORT
external: ${VPNIP}
timeout.io: 0
timeout.negotiate: 0
socksmethod: username none
#socksmethod: pam
#logoutput: stderr
#logoutput: /var/log/danted.log
user.notprivileged: nobody
client pass {
from: 0.0.0.0/0 to: 0.0.0.0/0
}
socks pass {
from: 0.0.0.0/0 to: 0.0.0.0/0 port gt 1023
command: bind
group: g${i}
}
socks pass {
from: 0.0.0.0/0 to: 0.0.0.0/0
command:  connect udpassociate
group: g${i}
}
socks pass {
from: 0.0.0.0/0 to: 0.0.0.0/0
command: bindreply udpassociate
}
socks block {
from: 0.0.0.0/0 to: 0.0.0.0/0
}

EOF
	#--------------------------------------------------------------#
done
#删除OPENVPN的原始配置文件
rm -f /etc/openvpn/openvpn_tcp.conf
rm -f /etc/openvpn/radiusplugin_tcp.cnf
rm -f /etc/openvpn/openvpn_udp.conf
rm -f /etc/openvpn/radiusplugin_udp.cnf

#合并防火墙脚本
cat $WORKPATH/fw01.sh  >  $WORKPATH/firewall.sh 
cat $WORKPATH/fw02.sh  >> $WORKPATH/firewall.sh 
cat $WORKPATH/fw03.sh  >> $WORKPATH/firewall.sh 
/bin/cp firewall.sh /usr/local/bin/
chmod u+x /usr/local/bin/firewall.sh
chkconfig pptpd off
chkconfig xl2tpd off
chkconfig openvpn on
chkconfig ipsec on
service openvpn restart
service ipsec restart
dos2unix /usr/local/bin/firewall.sh
/usr/local/bin/firewall.sh

tar -zxvf openswan-2.6.38.tar.gz
cd openswan-2.6.38
make programs install
cd $WORKPATH
service ipsec restart

echo "echo \"pptpd xl2tpd start finish\"" >> /usr/local/bin/startvpn.sh
chmod 755 /usr/local/bin/startvpn.sh && /usr/local/bin/startvpn.sh
echo "mknod /dev/ppp c 108 0" >> /etc/rc.local
echo "/usr/local/bin/startvpn.sh" >> /etc/rc.local

chmod 755 /usr/local/bin/startdanted.sh && /usr/local/bin/startdanted.sh
echo "/usr/local/bin/startdanted.sh" >> /etc/rc.local
