    current  = "Address Book";
    var help = "Get help regarding: " + current;
    var selectTitle = "Select an entry to modify from my address book...";
    var globalMode = 0;
    var globalForm;


    // This function and the href="JavaScipt:..." calls to it
    //  are to get along with NS on the Mac.
    function doButton4(form, sButton)
    {
      if (sButton == "Modify")
        verify1_ab(form);
      else if (sButton == "Delete")
        verify_ab(form);
      return;
    } // doButton

    function update(form)
    {
      var address, flag;  
      var i    = form.lstAddr.selectedIndex;
      var ip   = "";
      var j    = 0;    
      var user = "";

      if (i == -1)
	      return;

      flag=isContactListInUse(form, 1);
      if(flag==1)
      {
        // A contact list was selected

        var tempStr = new String(form.lstAddr.options[i].text);
        var tempLen = tempStr.length;

        form.txtUser.value = tempStr.substring(1,tempLen-1);
        form.txtUpdateList.value = displayContactList(form.lstAddr.options[i].value);

      }
      else
      {
        // An email address was selected

        address = form.lstAddr.options[i].text;  

        if (address == "--No Addresses--" || address == selectTitle || address.length == 0)
	      {
	        form.txtUser.value = "";
		      form.txtUpdateAddress.value = "";
          return;
        }
	      if (address == "" || (address.charAt(0)!='<' && address.charAt(0)!='"'))
        {
	        form.txtUser.value          = "";
	        form.txtUpdateAddress.value = "";
          return;
        }
        if (address.charAt(0) == '<')
        {
          i                                      = address.length;
	        form.txtUser.value          = "";
	        form.txtUpdateAddress.value = address.substring(j+1, i-1);
          return;
        }
        while (address.charAt(j) != '<')  
        {    
          j = j+1;
          if (j > address.length )
            break;
        }
        if (j > address.length)
        {
          j = 1;
          i = address.length;
        
          while (address.charAt(j) != '"')
            j = j + 1;
          form.txtUser.value = address.substring(1,j);
          if (address.charAt(i - 1) == '>')
            form.txtUpdateAddress.value = address.substring(j+2, i-1);
          else
            form.txtUpdateAddress.value = address.substring(j+2, i);
        } else
        {
          form.txtUser.value          = address.substring(1, j-2);
          i                                      = address.length;
          form.txtUpdateAddress.value = address.substring(j+1, i-1);
        }
      }
      return;     
    } // update

    function verify_ab(form)
    {
      var address;  
      var ch;
      var i = form.lstAddr.selectedIndex;

      if (i == -1)
	      return false;
	      
      address = form.lstAddr.options[i].text;  
      
      if (address == "--No Addresses--" || address == selectTitle)
        return false;
        
      form.button.value = "<!--IMAIL.DeleteButton-->";
      
      form.submit(); 
	    return true;
    } // verify

    function verify1_ab(form)
    {
      var address, duplicateFreeList;  
      var i = form.lstAddr.selectedIndex;
      var Modaddress;
      
      if (i == -1)
	      return;
	      
      address = form.lstAddr.options[i].text;  
      
      if (address == "--No Addresses--" || address == selectTitle)
      {
        return;
      }
      else
      {
        var flag=isContactListInUse(form, 1);
        if(flag==1)
        {
          // Editing a contact list
          if (form.txtUser.value == "")    
          {
            alert(X.AMsgEntConListName);
            form.txtUser.focus()
            return; 
          }
          if (form.txtUpdateList.value == "")    
          {
            alert(X.AMsgEntConListAddr);
            form.txtUpdateList.focus()
            return;  
          }

          form.formattedCList.value = formatContactList(form.txtUpdateList.value);

          if (form.formattedCList.value == "")    
          {
            alert(X.AMsgEntConListAddr);
            form.txtUpdateList.focus()
            return;  
          }

		  // MAN 09-10-03 - Copied this line from else condition
          // we were getting button= with no value and we apparently
          // needed button=Modify to update contact list
          form.button.value = "<!--IMAIL.ModifyButton-->";

          duplicateFreeList = removeDuplicates(form.formattedCList.value, ",");
        
          if(duplicateFreeList != "")
          {
             form.formattedCList.value = duplicateFreeList;
          }

        }
        else
        {
	        var Name, i = 0;
	        var ModyName, ModyAddress;

          if (form.txtUpdateAddress.value == "")
          {
              alert(X.EntUsrEmailAddr);
              return;
	        }
	        
          form.button.value = "<!--IMAIL.ModifyButton-->";
	        Name = form.txtUser.value;
	        
          if (Name.charAt(i) != '"')
            ModyName = '"' + Name;
          else
            ModyName = Name;
          
          i = Name.length;
        
          if (Name.charAt(i-1) != '"')
            ModyName = ModyName + '"';
          
          i    = 0;
          Name = form.txtUpdateAddress.value;
        
          if (Name.charAt(i) != '<')
            ModyAddress = '<' + Name;
          else
            ModyAddress = Name;
          
          i = Name.length;
        
          if (Name.charAt(i-1) != '>')
            ModyAddress = ModyAddress + '>';
          
          Modaddress = ModyName + ' ' + ModyAddress
        
          for (i = 0;i < form.lstAddr.length;i++ )
          {
            address = form.lstAddr.options[i].text;  
          
	          if (Modaddress == address)
            {
              var address1 = form.txtUpdateAddress.value
              var user1    = form.txtUser.value

              alert(X.AddrExists);
		          return;
	          }	
          }
        }
	      form.submit();
	      return;
      }
    } //  verify1

    function addnew(form)
    {
      var Name, i = 0, j = 0;
      var NewName, NewAddress;
      var temp, flag, duplicateFreeList;

      flag = isContactListInUse(form, 0);

      if(flag==1)
      {
        // Adding a contact list
        if (form.txtNewUser.value == "")    
        {
          alert(X.AMsgEntConListName);
          form.txtNewUser.focus();
          return; 
        }
        if (form.txtNewList.value == "")    
        {
          alert(X.AMsgEntConListAddr);
          form.txtNewList.focus();
          return;  
        }

        form.formattedCList.value = formatContactList(form.txtNewList.value);

        if (form.formattedCList.value == "")    
        {
          alert(X.AMsgEntConListAddr);
          form.txtNewList.focus();
          return;  
        }

        duplicateFreeList = removeDuplicates(form.formattedCList.value, ",");
        
        if(duplicateFreeList != "")
        {
           form.formattedCList.value = duplicateFreeList;
        }

        form.submit();
      }
      else
      {
        // Adding an email address
        if (document.Add.txtNewUser.value == "")    
        {
          alert(X.EntNewNameForAddr);
		  form.txtNewUser.focus();
          return;       
        } 
        if (document.Add.txtNewAddress.value == "")    
        {
          alert(X.EntNewAddr);
		  form.txtNewAddress.focus();
          return;       
        }  
      
        Name = document.Add.txtNewUser.value;
        temp = document.Add.txtNewUser.value;
        i    = temp.length;
      
        while (temp.charAt(j) == ' ')
          j = j + 1;
        
        temp = temp.substring(j, i);
        i    = temp.length - 1;
      
        while (temp.charAt(i) == ' ')
          i = i - 1;
        
        temp       = temp.substring(0, i + 1);
        Name       = temp;
        i          = 0;
        NewName    = Name;
        i          = 0;
        Name       = document.Add.txtNewAddress.value;
        NewAddress = Name;
        form.txtNewUser.value = NewName;
        form.txtNewAddress.value = NewAddress;
        form.submit(); 
      }
    
      return;    
    }

    function isContactListInUse(form, mode)
    {
      // This function is designed to determine if
      // the contact list text area control should
      // be displayed for the given
      // mode (i.e. addition or modification).  It
      // will return 1 if the contact list text
      // area control should be display, otherwise
      // it will return 0.

      if(mode==0)
      {
        // Addition mode
        if(form.selectType[1].checked)
        {
          return 1;
        }
        else
        {
          return 0;
        }
      }
      else if(mode==1)
      {
        // Modification mode
        var i    = form.lstAddr.selectedIndex;
        
        if (i == -1)
        {
          return 0;
        }
        else
        {
          var tempStr = new String(form.lstAddr.options[i].text);
          if(tempStr.charAt(0)=="[")
          {
            return 1;
          }
          else
          {
            return 0;
          }
        }
      }
      else
      {
        return 0;
      }
    }

    function clearFields(form)
    {
      form.txtNewUser.value = "";
      form.txtNewAddress.value = "";
      form.txtNewList.value = "";
    }

    function displayField(form, mode)
    {
      // This function will display either the
      // "Email" textbox or the "List" text area
      // based on the which mode is requested

      if(mode==0)
      {
        // Addition mode

        // Clear the fields
        clearFields(form);

        var flag = isContactListInUse(form, mode);
        if(flag==1)
        {
          // Show the Contact List controls
          // for adding a contact list
          show("add_CL_Label");
          show("add_CL_Field");

          // Hide the Email Address controls
          // for adding an email address
          hide("add_EA_Label");
          hide("add_EA_Field");
        }
        else
        {
          // Hide the Contact List controls
          // for adding a contact list
          hide("add_CL_Label");
          hide("add_CL_Field");

          // Show the Email Address controls
          // for adding an email address
          show("add_EA_Label");
          show("add_EA_Field");
        }
      }
      else if(mode==1)
      {
        // Modification mode
        var flag = isContactListInUse(form, mode);
        if(flag==1)
        {
          // Show the Contact List controls
          // for modifying a contact list
          show("mod_CL_Label");
          show("mod_CL_Field");

          // Hide the Email Address controls
          // for modifying an email address
          hide("mod_EA_Label");
          hide("mod_EA_Field");
        }
        else
        {
          // Hide the Contact List controls
          // for modifying a contact list
          hide("mod_CL_Label");
          hide("mod_CL_Field");

          // Show the Email Address controls
          // for modifying an email address
          show("mod_EA_Label");
          show("mod_EA_Field");
        }
      }
    }

    function formatContactList(textAreaStr)
    {
      // This function contructs a properly formatted 
      // contact list based on the data submitted via
      // a text string.  It returns a formatted
      // contact list.
      
      var rawString = new String(textAreaStr);
      var formattedStr, strLen; 
      
      // Convert all carriage return\new linefeeds to a comma
      rawString = rawString.replace(/\r\n/g, ",");

      // Convert all spaces to a comma
      rawString = rawString.replace(/\s+/g, ",");

      // Convert all multiple commas to a single comma;
      formattedStr = rawString.replace(/\,+/g,",");
      
      strLen = formattedStr.length;
      
      if(strLen < 3)
      {
        return "";
      }

      if(formattedStr.charAt(0) == ",")
      {
        // There is a comma at the beginning of the
        // string, which needs to be removed

        formattedStr = formattedStr.substring(1, strLen+1);
      }

      strLen = formattedStr.length;

      if(formattedStr.charAt(strLen - 1) == ",")
      {
        // There is a comma at the ending of the
        // string, which needs to be removed

        formattedStr = formattedStr.substring(0, strLen-1);
      }

      return formattedStr;
    }

    function displayContactList(formattedStr)
    {
      // This function converts the properly formatted 
      // contact list data for display purposes.

      var rawString = new String(formattedStr);
      var textAreaStr, strLen;

	  // Remove the number from string
	  var index1 = rawString.search(/\|/);
	  rawString = rawString.substring(index1 + 1,rawString.length);

      rawString = rawString.replace(/\</g,"");
      rawString = rawString.replace(/\>/g,"");

      textAreaStr = rawString.replace(/,/g,"\r\n");
      
      return textAreaStr;
    }

    function displayAddrBook(form, onOff, mode)
    {
      // This function must determine if the Address
      // Book should be displayed based on whether
      // the user is adding/modifying a contact list.
      // If the onOff variable is set to 1, the Address
      // Book should be displayed, if the flag is set
      // to 0, the Address Book should be hidden.

      if(onOff==1)
      {
        // Display the Address Book
        var flag = isContactListInUse(form, mode);
        if(flag==1)
        {
          show("addressBookDisplay");
        }
        if(mode==0)
        {
          // Highlight the Add an Entry's text area
          form.txtNewList.style.backgroundColor ="#FDFCD3";
        }
        else if(mode==1)
        {
          // Highlight the Modify an Entry's text area
          form.txtUpdateList.style.backgroundColor ="#FDFCD3";
        }

      }
      else
      {
        // Hide the Address Book
        hide("addressBookDisplay");
        if(document.Add.txtNewList)
        {
          document.Add.txtNewList.style.backgroundColor ="#FFFFFF";
        }
        if(document.Modify.txtUpdateList)
        {
          document.Modify.txtUpdateList.style.backgroundColor ="#FFFFFF";
        }
      }
    }

    function setMode(mode)
    {
      if(mode==0)
      {
        globalForm=document.Add;

      }
      else if(mode==1)
      {
        globalForm=document.Modify;
      }
      globalMode = mode;
    }

    function convertSelectedOptions(form)
    {
      // This function will convert the selected
      // options from the Address Book into
      // a properly formatted text string.  It
      // will return the formatted text string.

      var myCounter, tempStr, index1, index2;
      var finalResult="";
      
      if(form.abook.selectedIndex!=-1)
      {
        
        for(myCounter=0; myCounter < form.abook.options.length; myCounter++)
        {
          if(form.abook.options[myCounter].selected)
          {
            tempStr = new String(form.abook.options[myCounter].text);
            
            index1 = tempStr.search("<");
            index2 = tempStr.search(">");
            if((index1 > -1) || (index2 > -1))
            {
              finalResult += "," + tempStr.substring(index1 + 1,index2);
            }
          }
        }
      }
      return finalResult;
    }

    function insertAddr(myForm, form)
    {
      // This function takes the selected
      // options from the Address book and 
      // inserts them into the proper text area

      var textAreaObj;
      var tempStr;

      if(globalMode==0)
      {
        // Addition mode
        textAreaObj = form.txtNewList;
      }
      else if(globalMode==1)
      {
        // Modification mode
        textAreaObj = form.txtUpdateList;
      }

      tempStr = textAreaObj.value;
      tempStr += convertSelectedOptions(myForm);
      tempStr = formatContactList(tempStr);
      textAreaObj.value = displayContactList(tempStr);

      myForm.abook.selectedIndex=-1;
      displayAddrBook(globalForm, 0, globalMode);
    }

    function removeDuplicates(textStr, delimiter)
	  {
	    var tempStr = new String(textStr);
	    var entry = tempStr.split(delimiter);
	    var finalStr = "";
	    var i, x;
      var failFlag = 0;

	    if(entry.length >= 2)
	    {
        // There are two or more entries

	      for(i=0; i < entry.length; i++, failFlag=0)
	      {
          // Select the entry to compare

	        for(x=i+1; x < entry.length; x++)
		      {
            // Compare the selected entry
            // with the other entries

            if(entry[i] == entry[x])
            {
              // A duplicate has been found
              failFlag = 1;
              break;
            }
		      }
          
          if(failFlag == 0)
          {
            // Only include the entry into the
            // final list if it does not have
            // a duplicate

            if(finalStr == "")
            {
              finalStr += entry[i];
            }
            else
            {
              finalStr += delimiter + entry[i];
            }
          }
	      }
	    }

	    return finalStr;
	  }

