  function doButtonAction(form, buttonAction)
  {
    // This function is designed to respond
    // to the various button actions.  This
    // function is launched after a button
    // is clicked.


	  if (buttonAction == "<!--IMAIL.SaveButton-->"
	      || buttonAction == "<!--IMAIL.UpdateButton-->")
    {
	    // Construct the list that will be submitted in the POST
		  for(var x=0; x < form.theListEntry.options.length; x++)
		  {
		    if(form.theList.value=="")
		    {
		      form.theList.value += form.theListEntry.options[x].text;
		    }
		    else
		    {
		      form.theList.value += delimiter + form.theListEntry.options[x].text;
		    }
		  }

      form.imail_action.value = buttonAction;
      form.submit();
    }
	  else if (buttonAction == "<!--IMAIL.AddButton-->")
	  {
	    // Check to see if the entry is not already in the list
      if(isEntryInList(form, buttonAction) == 0)
		  {
		    resetListBoxForm(form);
		    return;
		  }

      // Check to see if the entry's value is NULL
      if(isEntryEmpty(form) == 0)
      {
        resetListBoxForm(form);
		    return;
      }
		
		  // Add the entry into the list
		  addListOption(form.theListEntry.options.length, form.entry.value, form.theListEntry);

		  resetListBoxForm(form);
	  }
	  else if (buttonAction == "Edit")
	  {
	    if (form.theListEntry.selectedIndex == -1)
	    {
		    alert("Please select an entry to edit from the "+listName+".");
		    form.theListEntry.focus();
		    return;
		  }

		  // Check to see if the entry is not already in the list
      if(isEntryInList(form, buttonAction) == 0)
		  {
		    form.entry.focus();
		    return;
		  }

      // Check to see if the entry's value is NULL
      if(isEntryEmpty(form) == 0)
      {
        form.entry.focus();
		    return;
      }

		  // Edit the specified entry in the list
	    editListOption(form.theListEntry.selectedIndex, form.entry.value, form.theListEntry);

	  	// Reset the list to its inital condtion
      resetListBoxForm(form);
	  }
	  else if (buttonAction == "<!--IMAIL.RemoveButton-->")
	  {
	    // Remove the specified entry from the list
  		removeListOption(form.theListEntry.selectedIndex, form.theListEntry);
	    
	    // Reset the list to its inital condtion
      resetListBoxForm(form);
	  }
  }

	function addListOption(optValue, optText, listObj)
	{
    // Add an option to the list
	  listObj.options[listObj.length] = new Option (optText,optValue);
	}

	function editListOption(optIndex, optText, listObj)
	{
    // Edit the selected option in the list
	  listObj.options[optIndex].text = optText;
	}

	function removeListOption(optIndex, listObj)
	{
    // Remove the selected option from the list
	  listObj.options[optIndex] = null;
	}

	function isEntryInList(form, buttonAction)
	{
	  // Check to see if value in the "entry" textbox is already in the list
	  for(var x=0; x < form.theListEntry.options.length; x++)
	  {
	    if(form.theListEntry.options[x].text==form.entry.value)
		  {
        if (buttonAction=="<!--IMAIL.AddButton-->")
        {
		      alert("The "+entryName+", \""+form.entry.value+"\" is already in the "+listName+"; therefore, the "+entryName+" will not be added to the "+listName+".");
        }
        else if (buttonAction=="Edit")
        {
          alert("The "+entryName+", \""+form.entry.value+"\" is already in the "+listName+"; therefore, your changes will not be saved to the "+listName+". \n\nNote: Use the text field, on this form, to make modifications to the selected entry.");
        }
		    return 0;
		  }
	  }
	  return 1;
	}

  function isEntryEmpty(form)
  {
    // Check to see if the value in the "entry" textbox is NULL
    if(form.entry.value.length <= 0)
    {
      alert("Please enter a valid "+entryName+" in the text field.")
      return 0;
    }
    return 1;
  }

	function changeModeTo(form, mode)
	{
    // This function changes the mode for the list box.  The three modes
    // are "Edit", "Add," and "Disable."  If the list box is in "Edit" mode,
    // the add, edit, and remove buttons should be enabled.  It the list box
    // is in "Add" mode, only the add button should be enabled.  If the
    // list box is in "Disable" mode, all controls are disabled.

	  if (mode=="Edit")
	  {
	  	var i = form.theListEntry.selectedIndex;
  		if(i != -1)
	  	{
		    form.editBtn.disabled = 0;
		    form.removeBtn.disabled = 0;

		    form.entry.value = form.theListEntry.options[i].text;
		    form.entry.focus();
		  }
    }

	  if (mode=="Add")
	  {
	    form.editBtn.disabled = 1;
		  form.removeBtn.disabled = 1;
		  form.addBtn.disabled = 0;
		
		  form.theListEntry.selectedIndex = -1;
      form.theListEntry.disabled = 0;
      form.entry.disabled = 0;
		  form.entry.focus();
	  }

    if (mode=="Disable")
    {
      // Disabling the buttons
      form.addBtn.disabled = 1;
      form.editBtn.disabled = 1;
		  form.removeBtn.disabled = 1;
		  
      // Disabling the entry text box
      form.entry.disabled = 1;
      
      // Disabling the listbox containing
      // all of the entries
      form.theListEntry.selectedIndex = -1;
      form.theListEntry.disabled = 1;
    }
	}

	function resetListBoxForm(form)
	{
    // This function resets the list box
    // back to its initial condition


	  // Clear the entry textbox
	  form.entry.value = "";

	  // Deselect the entry in the list box
	  form.theListEntry.selectedIndex = -1;

	  // Change to "add" mode
	  changeModeTo(form, "Add")
	  
	}

  function disableTextbox(form)
  {
    // Disable the text box if
    // the "Delete" option or the
    // "Insert X-header" option
    // is selected.

    var mode;
    var color;

    i = form.actionListEntry.selectedIndex;
    if(form.actionListEntry.options[i].value == 0 || form.actionListEntry.options[i].value == 2)
    {
      mode = 1;
      color = "#E2E2E2";
      form.actionAddress.value = "";
    }
    else
    {
      mode = 0;
      color = "#FFFFFF";
      
      // If there is no address currently in
      // in the "Address" field, use the default
      // value, which is "root-bulk"
      if(form.actionAddress.value.length==0)
      {
        form.actionAddress.value = "root-bulk";
      }
    }

    form.actionAddress.disabled = mode;
	  form.actionAddress.style.background = color;
    
  }