  function doButton_editrule(form,sButton)
  {
	  var exit = 2;

	  switch(sButton)
	  {
	    case "Update":
		  form.operadd.value = sButton;
		  exit = 3;
		  break;
		case "Finish":
		  form.operadd.value = sButton;
		  exit = 1;
		  break;
		case "Add":
		  form.operadd.value = sButton;
		  exit = 0;
		  break;
		case "Change":
		  form.operadd.value = sButton;
		  exit = 0;
		  break;
		case "And":
		  form.operadd.value = sButton;
		  break;
		case "Or":
		  form.operadd.value = sButton;
		  break;
		case "Remove":
		  form.operadd.value = sButton;
		  break;
		case "Up":
		  form.operadd.value = sButton;
		  break;
		case "Down":
		  form.operadd.value = sButton;
		  break;
		default:
		  break;
	  }
	  
	  form.finalRule.value = makeFinalRule(form, exit);
	  if(form.finalRule.value == 0)
	  {
	    return;
	  }
	  
	  if (validateMe(form, exit))
	  {
	    clearListBox(form);
	    clearSearchArea_editrule(document.AddRule);
	  }
  }
    
  function clearSearchArea_editrule(form)
  {
    if (form.searchfile.checked == true)
    {
      form.rulecontents.value = " ";
    }
    else
  	{
	    var searchString = form.rulecontents.value;
  
  	  if (searchString.length > 255)
      {
        alert("The text phrase is greater than 255 characters.")
        return;
      }
	  }
  	form.submit();
  }

  function clearSearchContents_editrule(form)
  {
    form.rulecontents.value = " ";
  }

	function displayRule(form)
	{
	  //var msg = "This is the function that will parse the value of the selected option.";
	  //alert(msg);
	  var i = form.rulelist.selectedIndex;
	  var text = "";
	  var tempStr;
	  var gray = 1;
	  

	  // Determine if an option is selected from
	  // the "rulelist" list box
	  
	  if (i != -1)
	  {
	    tempStr = form.rulelist.options[i].value;
		
		
		// Select the option from the "field" list box whose
		// value is equal to the first character of the selected
		// option from the "rulelist" list box

		for (var x=0; x < form.field.length; x++)
		{
		  if (tempStr.charAt(0) == form.field.options[x].value)
		  {
		    form.field.options[x].selected = 1;
			gray = 0;
			break;
		  }
		  else
		  {
		    gray = 1;
		  }
		}
		
		// Determine the condition of the rule
		
		if (tempStr.charAt(1) == "~")
		{
		  form.condition[0].checked = 1;
		  form.rulecase.checked = 0;
		  text = tempStr.substring(2,tempStr.length+1);
		}
		if (tempStr.charAt(1) == "=")
		{
		  form.condition[0].checked = 1;
		  form.rulecase.checked = 1;
		  text = tempStr.substring(2,tempStr.length+1);
		}
		if (tempStr.charAt(1) == "!")
		{
		  if (tempStr.charAt(2) == "~")
		  {
		    form.condition[1].checked = 1;
			form.rulecase.checked = 0;
			text = tempStr.substring(3,tempStr.length+1);
		  }
		  if (tempStr.charAt(2) == "=")
		  {
		    form.condition[1].checked = 1;
			form.rulecase.checked = 1;
			text = tempStr.substring(3,tempStr.length+1);
		  }
		}
		
		// Determine if search phrase is in a file
		
		if (text.charAt(0) == ":")
		{
		  // Display rule content in file

		  var fileName = text.substring(2,text.length+1);
		  form.searchfile.checked = 1;
		  form.rulecontents.value = "";

		  for (var x=0; x < form.rulefile.length; x++)
		  {
		    if (form.rulefile.value == fileName)
			{
			  form.rulefile.options[x].selected = 1;
			}
		  }
		}
		else
		{

		  // Display the rule content in text box

		  form.searchfile.checked = 0;
		  form.rulecontents.value = text;
		  form.rulefile.selectedIndex = -1;
		}

	  }
	  else
	  {
		gray = 1;
	  }

	  if (gray == 1)
	  {
	    grayForm(form);
	  }
	  else
	  {
	    colorForm(form,'#FFFFFF');
	  }
	}

	function grayForm(form)
	{
	  form.field.selectedIndex = -1;
	  form.condition[0].checked = 0;
	  form.condition[1].checked = 0;
	  form.rulecontents.value = "";
	  form.rulecase.checked = 0;
	  form.searchfile.checked = 0;
	  form.rulefile.selectedIndex = -1;

	  colorForm(form,'#E2E2E2');
	}

	function colorForm(form, color)
	{
	  
	  form.field.style.background = color;
	  //form.condition[0].style.background = color;
	  //form.condition[1].style.background = color;
	  form.rulecontents.style.background = color;
	  //form.rulecase.style.background = color;
	  //form.searchfile.style.background = color;
	  form.rulefile.style.background = color;
	}

	function makeFinalRule(form, onExit)
	{
	  var tempRule = "";
	  var delimiter = "||";
	  var tempStr = "";
	  var subtypeArray = new Array("+", "+!COPY!", "+", "!BOUNCE!", "NUL")

	  for (var x=0; x < form.rulelist.length; x++)
	  {
		if(onExit == 1)
		{
		  tempStr = form.rulelist.options[x].value;
		  if (x == 0)
		  {
		    if (tempStr.charAt(0) != "!")
			{
			  tempRule += form.rulelist.options[x].value;
			}
			else
			{
			  alert("The first segment in the rule cannot be an \"" + tempStr.substring(1,tempStr.length -1) + "\".");
			  form.rulelist.options[x].selected = 1;
			  return 0;
			}
		  }
		  else
		  {
		    if ((x % 2)!=0 && tempStr.charAt(0) != "!")
			{
			  // If x is an odd number and the first character does not equal "!" 
			  // this let us know that there is an extra rule segment in the rule

			  alert("The rule segment is not positioned in the rule correctly.");
			  form.rulelist.options[x].selected = 1;
			  return 0;
			}
			else if ((x % 2)==0 && tempStr.charAt(0) == "!")
			{
			  // If x is an even number and the first character does equal "!"
			  // this let us know that there is an extra AND or OR condition

			  alert("The rule segment is not positioned in the rule correctly.");
			  form.rulelist.options[x].selected = 1;
			  return 0;
			}
			else if (tempStr.charAt(0) == "!" && x == (form.rulelist.length - 1))
			{
			  alert("The last segment in the rule cannot be an \"" + tempStr.substring(1,tempStr.length -1) + "\".");
			  form.rulelist.options[x].selected = 1;
			  return 0;
			}
			else
			{
			  tempRule += form.rulelist.options[x].value;
			}
		  }
		}
		else
		{
		  if (x == 0)
		  {
		    tempRule += form.rulelist.options[x].value;
		  }
		  else
		  {
		    tempRule += delimiter + form.rulelist.options[x].value;
		  }
		}
	  }
	  if(tempRule == "" && onExit == 1)
	  {
	    alert("Invalid rule: The rule will not be added to the file.");
		return 0;
	  }
	  else
	  {
	    if (form.subtype.selectedIndex > -1 || form.subtype.selectedIndex < subtypeArray.length)
	    {
	      var i = form.subtype.selectedIndex;
	      var obformat = subtypeArray[form.subtype.options[i].value];
		  if (obformat.charAt(0) == "+")
		  {
		    var tempSrcStr = new String(form.destination.value);
			  if((tempSrcStr.search("@") != -1) && form.subtype.selectedIndex == 0)
			  {
			    alert("Invalid mailbox name: \n\nThe '@' symbol is not allowed. ");
			    form.destination.focus();
			    return 0;
			  }
        if((tempSrcStr.search("@") == -1) && form.subtype.selectedIndex == 2)
			  {
			    alert("Invalid email address: \n\nPlease enter the full email address. ");
			    form.destination.focus();
			    return 0;
			  }
        if((tempSrcStr.search(/\\|\//) != -1) && form.subtype.selectedIndex == 2)
			  {
			    alert("Invalid email address: \n\nThere is an invalid symbol. ");
			    form.destination.focus();
			    return 0;
			  }

        if((form.subtype.selectedIndex != 2) && (form.subtype.selectedIndex != 1))
        {
			    // Replacing all '/' and '.' symbols with a '\'
			    tempSrcStr = tempSrcStr.replace(/\/|\./g, "\\");
        }
        else if(form.subtype.selectedIndex == 1)
        {
          // If the "Send Copy To" option has been selected, the user
          // can enter an email address or a mailbox name

          if(tempSrcStr.search("@") == -1)
          {
            // The user has entered a mailbox or an invalid email address.
            // Treat the entry as a mailbox, and replace all '/' and '.'
            // with a '\'

            tempSrcStr = tempSrcStr.replace(/\/|\./g, "\\");

          }
        }
        
        tempRule += ":" + obformat.substring(1,obformat.length+1) + tempSrcStr;
		  }
		  else
		  {
		    tempRule += ":" + obformat;
		  }
	    }
	    else
	    {
	      tempRule += ":" + subtypeArray[0];
	    }
	  }
	  return tempRule;
	}

	function validateSelect(form, sButton)
	{
	  if(form.rulelist.selectedIndex != -1)
	  {
	    doButton_editrule(form,sButton);
	  }
	  else
	  {
	    alert("Please select an option from the list box to move \""+ sButton +".\"");
	  }
	}

	function clearListBox(form)
	{
	  for (var x=0; x < form.rulelist.length; x++)
	  {
	    form.rulelist.options[x].value = x;
	  }
	}

	function setCondition(form)
	{
	  if (form.rulecase.checked == 1)
	  {
	    form.condition[0].value = "="
		form.condition[1].value = "!="
	  }
	  else
	  {
	    form.condition[0].value = "~"
		form.condition[1].value = "!~"
	  }
	}

	function validateMe(form, level)
	{
	  if(level == 2)
	  {
	   	if (form.rulelist.selectedIndex == -1)
		{
		  alert("Please select a rule segment from the list box");
		  form.rulelist.focus();
		  return 0;
		}
	    return 1; 
	  }
	  else if (level == 0)
	  {
	    // The user is just adding or updating a rule
		
		if(form.field.selectedIndex == -1)
		{
		  alert("Please select a message area from the list box.");
		  form.field.focus();
		  return 0;
		}
		if(form.condition[0].checked==0 && form.condition[1].checked==0)
		{
		  alert("Please select a condition.");
		  form.condition[0].focus();
		  return 0;
		}
		if(form.rulecontents.value == "" && form.searchfile.checked != 1)
		{
		  alert("Please enter some content for the rule.");
		  form.rulecontents.focus();
		  return 0;
		}
		if(form.searchfile.checked == 1 && form.rulecontents.value != "")
		{
		  alert("Content cannot be placed in the PHRASE field if the rule segment should read from a rule file.")
		  form.rulecontents.focus();
		  return 0;
		}
		if(form.searchfile.checked == 1 && form.rulefile.selectedIndex == -1)
		{
		  alert("Please select a rule file from the list box.");
		  form.rulefile.focus();
		  return 0;
		}
		if(form.operadd.value == "Change" && form.rulelist.selectedIndex == -1)
		{
		  alert("Please select a rule segment from the list box to update.");
		  form.rulelist.focus();
		  return 0;
		}

		return 1;
	  }
	  else
	  {
	    return 1;
	  }

	}

	function sizeListbox(listBox)
	{
	  // This function is designed to limit the length
	  // of the SELECT options for a given list box.
	  
	  for(var x=0; x < listBox.length; x++)
	  {
	    if(listBox.options[x].text.length > 65)
		{
		  var tempStr = new String(listBox.options[x].text);
		  tempStr = tempStr.substr(0, 65) + "...";
		  listBox.options[x].text = tempStr;
		}
	  }
	}

	function selectMsgRadio(form, mode)
	{
	  if (mode == 0)
	  {
	    var mbxOrAddr = new String(form.sendTo.value);

		<!--IMAIL.BeginIfDeleteRuleMsg-->
	    form.msgOpt[2].checked = 1;
	    <!--IMAIL.ElseBeginIfDeleteRuleMsg-->
	    if (mbxOrAddr.search("@") != -1)
	    {
	      form.sendToAddr.value = mbxOrAddr;
		  form.msgOpt[1].checked = 1;
	    }
	    else
	    {
	      form.sendToMbx.value = mbxOrAddr.replace(/\\/g,".");
		  form.sendToMbx.style.background='#FFFFFF';
		  form.sendToAddr.style.background='#E2E2E2';
		  form.msgOpt[0].checked = 1;
	    }
		<!--IMAIL.EndBeginIfDeleteRuleMsg-->
	  }

	  if(form.msgOpt[2].checked == 1)
	  {
	    form.sendToMbx.style.background='#E2E2E2';
		form.sendToAddr.style.background='#E2E2E2';
	  }
	  else if (form.msgOpt[0].checked == 1)
	  {
	    form.sendToMbx.style.background='#FFFFFF';
		form.sendToAddr.style.background='#E2E2E2';
	  }
	  else if (form.msgOpt[1].checked == 1)
	  {
	    form.sendToMbx.style.background='#E2E2E2';
		form.sendToAddr.style.background='#FFFFFF';
	  }
	}

  function disableTextbox(form)
	{
	  if (form.subtype.options[3].selected==1 || form.subtype.options[4].selected==1)
	  {
      // Disable the "destination" textbox
	    form.destination.style.background='#E2E2E2'
	  }
	  else
	  {
      // Enable the "destination" textbox
	    form.destination.style.background='#FFFFFF'
	  }
	}

	function startUp()
	{
	  statusBarMsg(current);
	  grayForm(document.AddRule);
	  sizeListbox(document.AddRule.rulelist);
	  //selectMsgRadio(document.AddRule, 0);
    disableTextbox(document.AddRule);
	}